/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.groups;

import java.util.List;
import net.sf.jabref.logic.importer.ParseException;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.strings.QuotedStringTokenizer;
import net.sf.jabref.model.groups.AbstractGroup;
import net.sf.jabref.model.groups.AllEntriesGroup;
import net.sf.jabref.model.groups.ExplicitGroup;
import net.sf.jabref.model.groups.GroupHierarchyType;
import net.sf.jabref.model.groups.GroupTreeNode;
import net.sf.jabref.model.groups.KeywordGroup;
import net.sf.jabref.model.groups.SearchGroup;
import net.sf.jabref.model.strings.StringUtil;

public class GroupsParser {
    public static GroupTreeNode importGroups(List<String> orderedData, Character keywordSeparator) throws ParseException {
        try {
            GroupTreeNode cursor = null;
            GroupTreeNode root = null;
            for (String string : orderedData) {
                if ((string = string.trim()).isEmpty()) continue;
                int spaceIndex = string.indexOf(32);
                if (spaceIndex <= 0) {
                    throw new ParseException("Expected \"" + string + "\" to contain whitespace");
                }
                int level = Integer.parseInt(string.substring(0, spaceIndex));
                AbstractGroup group = GroupsParser.fromString(string.substring(spaceIndex + 1), keywordSeparator);
                GroupTreeNode newNode = GroupTreeNode.fromGroup(group);
                if (cursor == null) {
                    root = cursor = newNode;
                    continue;
                }
                while (level <= cursor.getLevel()) {
                    cursor = (GroupTreeNode)cursor.getParent().get();
                }
                cursor.addChild(newNode);
                cursor = newNode;
            }
            return root;
        }
        catch (ParseException e) {
            throw new ParseException(Localization.lang("Group tree could not be parsed. If you save the BibTeX database, all groups will be lost.", new String[0]), e);
        }
    }

    public static AbstractGroup fromString(String s, Character keywordSeparator) throws ParseException {
        if (s.startsWith("KeywordGroup:")) {
            return GroupsParser.keywordGroupFromString(s, keywordSeparator);
        }
        if (s.startsWith("AllEntriesGroup:")) {
            return GroupsParser.allEntriesGroupFromString(s);
        }
        if (s.startsWith("SearchGroup:")) {
            return GroupsParser.searchGroupFromString(s);
        }
        if (s.startsWith("ExplicitGroup:")) {
            return GroupsParser.explicitGroupFromString(s, keywordSeparator);
        }
        return null;
    }

    public static AbstractGroup keywordGroupFromString(String s, Character keywordSeparator) throws ParseException {
        if (!s.startsWith("KeywordGroup:")) {
            throw new IllegalArgumentException("KeywordGroup cannot be created from \"" + s + "\".");
        }
        QuotedStringTokenizer tok = new QuotedStringTokenizer(s.substring("KeywordGroup:".length()), ";", '\\');
        String name = tok.nextToken();
        int context = Integer.parseInt(tok.nextToken());
        String field = tok.nextToken();
        String expression = tok.nextToken();
        boolean caseSensitive = Integer.parseInt(tok.nextToken()) == 1;
        boolean regExp = Integer.parseInt(tok.nextToken()) == 1;
        return new KeywordGroup(StringUtil.unquote(name, '\\'), StringUtil.unquote(field, '\\'), StringUtil.unquote(expression, '\\'), caseSensitive, regExp, GroupHierarchyType.getByNumber(context), keywordSeparator);
    }

    public static ExplicitGroup explicitGroupFromString(String s, Character keywordSeparator) throws ParseException {
        if (!s.startsWith("ExplicitGroup:")) {
            throw new IllegalArgumentException("ExplicitGroup cannot be created from \"" + s + "\".");
        }
        QuotedStringTokenizer tok = new QuotedStringTokenizer(s.substring("ExplicitGroup:".length()), ";", '\\');
        String name = tok.nextToken();
        int context = Integer.parseInt(tok.nextToken());
        ExplicitGroup newGroup = new ExplicitGroup(name, GroupHierarchyType.getByNumber(context), keywordSeparator);
        GroupsParser.addLegacyEntryKeys(tok, newGroup);
        return newGroup;
    }

    private static void addLegacyEntryKeys(QuotedStringTokenizer tok, ExplicitGroup group) {
        while (tok.hasMoreTokens()) {
            String key = StringUtil.unquote(tok.nextToken(), '\\');
            group.addLegacyEntryKey(key);
        }
    }

    public static AbstractGroup allEntriesGroupFromString(String s) {
        if (!s.startsWith("AllEntriesGroup:")) {
            throw new IllegalArgumentException("AllEntriesGroup cannot be created from \"" + s + "\".");
        }
        return new AllEntriesGroup(Localization.lang("All entries", new String[0]));
    }

    public static AbstractGroup searchGroupFromString(String s) {
        if (!s.startsWith("SearchGroup:")) {
            throw new IllegalArgumentException("SearchGroup cannot be created from \"" + s + "\".");
        }
        QuotedStringTokenizer tok = new QuotedStringTokenizer(s.substring("SearchGroup:".length()), ";", '\\');
        String name = tok.nextToken();
        int context = Integer.parseInt(tok.nextToken());
        String expression = tok.nextToken();
        boolean caseSensitive = Integer.parseInt(tok.nextToken()) == 1;
        boolean regExp = Integer.parseInt(tok.nextToken()) == 1;
        return new SearchGroup(StringUtil.unquote(name, '\\'), StringUtil.unquote(expression, '\\'), caseSensitive, regExp, GroupHierarchyType.getByNumber(context));
    }
}

