/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.formatter.casechanger;

import net.sf.jabref.logic.formatter.casechanger.Title;
import net.sf.jabref.logic.formatter.casechanger.Word;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.cleanup.Formatter;

public class UpperCaseFormatter
implements Formatter {
    @Override
    public String getName() {
        return Localization.lang("Upper case", new String[0]);
    }

    @Override
    public String getKey() {
        return "upper_case";
    }

    @Override
    public String format(String input) {
        Title title = new Title(input);
        title.getWords().stream().forEach(Word::toUpperCase);
        return title.toString();
    }

    @Override
    public String getDescription() {
        return Localization.lang("Changes all letters to upper case.", new String[0]);
    }

    @Override
    public String getExampleInput() {
        return "Kde {Amarok}";
    }
}

