/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.formatter.casechanger;

import java.util.List;
import java.util.Objects;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.protectedterms.ProtectedTermsLoader;
import net.sf.jabref.logic.util.strings.StringLengthComparator;
import net.sf.jabref.model.cleanup.Formatter;

public class ProtectTermsFormatter
implements Formatter {
    private static ProtectedTermsLoader protectedTermsLoader;

    @Deprecated
    public ProtectTermsFormatter() {
    }

    public ProtectTermsFormatter(ProtectedTermsLoader protectedTermsLoader) {
        ProtectTermsFormatter.protectedTermsLoader = protectedTermsLoader;
    }

    @Deprecated
    public static void setProtectedTermsLoader(ProtectedTermsLoader loader) {
        protectedTermsLoader = loader;
    }

    private String format(String text, List<String> listOfWords) {
        String result = text;
        listOfWords.sort(new StringLengthComparator());
        for (String listOfWord : listOfWords) {
            result = result.replaceAll("(^|[- /\\[(}\"])" + listOfWord + "($|[^a-zA-Z}])", "$1\\{" + listOfWord + "\\}$2");
        }
        return result;
    }

    @Override
    public String format(String text) {
        Objects.requireNonNull(text);
        if (text.isEmpty()) {
            return text;
        }
        Objects.requireNonNull(protectedTermsLoader);
        return this.format(text, protectedTermsLoader.getProtectedTerms());
    }

    @Override
    public String getDescription() {
        return Localization.lang("Adds {} brackets around acronyms, month names and countries to preserve their case.", new String[0]);
    }

    @Override
    public String getExampleInput() {
        return "In CDMA";
    }

    @Override
    public String getName() {
        return Localization.lang("Protect terms", new String[0]);
    }

    @Override
    public String getKey() {
        return "protect_terms";
    }
}

