/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.formatter.casechanger;

import net.sf.jabref.logic.formatter.casechanger.Title;
import net.sf.jabref.logic.formatter.casechanger.Word;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.cleanup.Formatter;

public class LowerCaseFormatter
implements Formatter {
    @Override
    public String getName() {
        return Localization.lang("Lower case", new String[0]);
    }

    @Override
    public String getKey() {
        return "lower_case";
    }

    @Override
    public String format(String input) {
        Title title = new Title(input);
        title.getWords().stream().forEach(Word::toLowerCase);
        return title.toString();
    }

    public int hashCode() {
        return this.defaultHashCode();
    }

    public boolean equals(Object obj) {
        return this.defaultEquals(obj);
    }

    @Override
    public String getDescription() {
        return Localization.lang("Changes all letters to lower case.", new String[0]);
    }

    @Override
    public String getExampleInput() {
        return "KDE {Amarok}";
    }
}

