/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.formatter.bibtexfields;

import java.util.Map;
import java.util.Objects;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.layout.LayoutFormatter;
import net.sf.jabref.model.cleanup.Formatter;
import net.sf.jabref.model.strings.HTMLUnicodeConversionMaps;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnicodeToLatexFormatter
implements LayoutFormatter,
Formatter {
    private static final Log LOGGER = LogFactory.getLog(UnicodeToLatexFormatter.class);

    @Override
    public String format(String text) {
        int i;
        String result = Objects.requireNonNull(text);
        if (result.isEmpty()) {
            return result;
        }
        for (Map.Entry<String, String> unicodeLatexPair : HTMLUnicodeConversionMaps.UNICODE_LATEX_CONVERSION_MAP.entrySet()) {
            result = result.replace(unicodeLatexPair.getKey(), unicodeLatexPair.getValue());
        }
        StringBuilder sb = new StringBuilder();
        boolean consumed = false;
        for (i = 0; i <= result.length() - 2; ++i) {
            if (!consumed && i < result.length() - 1) {
                int cpCurrent = result.codePointAt(i);
                Integer cpNext = result.codePointAt(i + 1);
                String code = HTMLUnicodeConversionMaps.ESCAPED_ACCENTS.get(cpNext);
                if (code == null) {
                    sb.append((char)cpCurrent);
                    continue;
                }
                sb.append("{\\").append(code).append('{').append((char)cpCurrent).append("}}");
                consumed = true;
                continue;
            }
            consumed = false;
        }
        if (!consumed) {
            sb.append((char)result.codePointAt(result.length() - 1));
        }
        result = sb.toString();
        for (i = 0; i <= result.length() - 1; ++i) {
            int cp = result.codePointAt(i);
            if (cp < 129) continue;
            LOGGER.warn("Unicode character not converted: " + cp);
        }
        return result;
    }

    @Override
    public String getDescription() {
        return Localization.lang("Converts Unicode characters to LaTeX encoding.", new String[0]);
    }

    @Override
    public String getExampleInput() {
        return "M\u00f6nch";
    }

    @Override
    public String getName() {
        return Localization.lang("Unicode to LaTeX", new String[0]);
    }

    @Override
    public String getKey() {
        return "unicode_to_latex";
    }
}

