/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.formatter.bibtexfields;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.cleanup.Formatter;

public class OrdinalsToSuperscriptFormatter
implements Formatter {
    private static final Pattern SUPERSCRIPT_DETECT_PATTERN = Pattern.compile("\\b(\\d+)(st|nd|rd|th)\\b", 10);
    private static final String SUPERSCRIPT_REPLACE_PATTERN = "$1\\\\textsuperscript{$2}";

    @Override
    public String getName() {
        return Localization.lang("Ordinals to LaTeX superscript", new String[0]);
    }

    @Override
    public String getKey() {
        return "ordinals_to_superscript";
    }

    @Override
    public String format(String value) {
        Objects.requireNonNull(value);
        if (value.isEmpty()) {
            return value;
        }
        Matcher matcher = SUPERSCRIPT_DETECT_PATTERN.matcher(value);
        return matcher.replaceAll(SUPERSCRIPT_REPLACE_PATTERN);
    }

    @Override
    public String getDescription() {
        return Localization.lang("Converts ordinals to LaTeX superscripts.", new String[0]);
    }

    @Override
    public String getExampleInput() {
        return "11th";
    }
}

