/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.formatter.bibtexfields;

import java.util.Objects;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.cleanup.Formatter;
import net.sf.jabref.model.entry.AuthorList;

public class NormalizeNamesFormatter
implements Formatter {
    @Override
    public String getName() {
        return Localization.lang("Normalize names of persons", new String[0]);
    }

    @Override
    public String getKey() {
        return "normalize_names";
    }

    @Override
    public String format(String nameList) {
        Objects.requireNonNull(nameList);
        AuthorList authorList = AuthorList.parse(nameList);
        return authorList.getAsLastFirstNamesWithAnd(false);
    }

    @Override
    public String getDescription() {
        return Localization.lang("Normalizes lists of persons to the BibTeX standard.", new String[0]);
    }

    @Override
    public String getExampleInput() {
        return "Albert Einstein and Alan Turing";
    }
}

