/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.formatter.bibtexfields;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.cleanup.Formatter;

public class NormalizeDateFormatter
implements Formatter {
    @Override
    public String getName() {
        return Localization.lang("Normalize date", new String[0]);
    }

    @Override
    public String getKey() {
        return "normalize_date";
    }

    @Override
    public String format(String value) {
        Optional<TemporalAccessor> parsedDate = this.tryParseDate(value);
        if (!parsedDate.isPresent()) {
            return value;
        }
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("uuuu-MM[-dd]");
        return dateFormatter.format(parsedDate.get());
    }

    @Override
    public String getDescription() {
        return Localization.lang("Normalizes the date to ISO date format.", new String[0]);
    }

    @Override
    public String getExampleInput() {
        return "29.11.2003";
    }

    private Optional<TemporalAccessor> tryParseDate(String dateString) {
        List<String> formatStrings = Arrays.asList("uuuu-M-d", "uuuu-M", "M/uu", "M/uuuu", "MMMM d, uuuu", "MMMM, uuuu", "d.M.uuuu", "uuuu.M.d");
        for (String formatString : formatStrings) {
            try {
                return Optional.of(DateTimeFormatter.ofPattern(formatString).parse(dateString));
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return Optional.empty();
    }

    public int hashCode() {
        return this.defaultHashCode();
    }

    public boolean equals(Object obj) {
        return this.defaultEquals(obj);
    }
}

