/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.formatter.bibtexfields;

import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.cleanup.Formatter;

public class LatexCleanupFormatter
implements Formatter {
    @Override
    public String getName() {
        return Localization.lang("LaTeX cleanup", new String[0]);
    }

    @Override
    public String getKey() {
        return "latex_cleanup";
    }

    @Override
    public String format(String oldString) {
        String newValue = oldString;
        newValue = newValue.replace("$$", "").replaceAll("(?<!\\\\[\\p{Alpha}]{0,100}\\{[^\\}]{0,100})\\}([-/ ]?)\\{", "$1");
        newValue = newValue.replaceAll("(([^$]|\\\\\\$)*)\\$", "$1@@");
        newValue = newValue.replaceAll("([^@]*)@@([^@]*)@@", "$1\\$$2@@");
        newValue = newValue.replaceAll("([0-9\\(\\.]+[ ]?[-+/]?[ ]?)\\$", "\\$$1");
        newValue = newValue.replaceAll("@@([ ]?[-+/]?[ ]?[0-9\\)\\.]+)", " $1@@");
        newValue = newValue.replace("@@", "$");
        newValue = newValue.replace("  ", " ");
        newValue = newValue.replace("$$", "");
        newValue = newValue.replace(" )$", ")$");
        return newValue;
    }

    @Override
    public String getDescription() {
        return Localization.lang("Cleans up LaTeX code.", new String[0]);
    }

    @Override
    public String getExampleInput() {
        return "{VLSI} {DSP}";
    }
}

