/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.exporter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Set;
import java.util.TreeSet;

public class VerifyingWriter
extends OutputStreamWriter {
    private final CharsetEncoder encoder;
    private boolean couldEncodeAll = true;
    private final Set<Character> problemCharacters = new TreeSet<Character>();

    public VerifyingWriter(OutputStream out, Charset encoding) {
        super(out, encoding);
        this.encoder = encoding.newEncoder();
    }

    @Override
    public void write(String str) throws IOException {
        super.write(str);
        if (!this.encoder.canEncode(str)) {
            for (int i = 0; i < str.length(); ++i) {
                if (this.encoder.canEncode(str.charAt(i))) continue;
                this.problemCharacters.add(Character.valueOf(str.charAt(i)));
            }
            this.couldEncodeAll = false;
        }
    }

    public boolean couldEncodeAll() {
        return this.couldEncodeAll;
    }

    public String getProblemCharacters() {
        StringBuilder chars = new StringBuilder();
        for (Character ch : this.problemCharacters) {
            chars.append(ch.charValue());
        }
        return chars.toString();
    }
}

