/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.exporter;

import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;

public class SaveException
extends Exception {
    public static final SaveException FILE_LOCKED = new SaveException("Could not save, file locked by another JabRef instance.", Localization.lang("Could not save, file locked by another JabRef instance.", new String[0]));
    public static final SaveException BACKUP_CREATION = new SaveException("Unable to create backup", Localization.lang("Unable to create backup", new String[0]));
    private final BibEntry entry;
    private int status;
    private String localizedMessage;

    public SaveException(String message) {
        super(message);
        this.entry = null;
    }

    public SaveException(String message, String localizedMessage) {
        super(message);
        this.localizedMessage = localizedMessage;
        this.entry = null;
    }

    public SaveException(String message, int status) {
        super(message);
        this.entry = null;
        this.status = status;
    }

    public SaveException(String message, BibEntry entry) {
        super(message);
        this.entry = entry;
    }

    public SaveException(String message, String localizedMessage, BibEntry entry) {
        super(message);
        this.localizedMessage = localizedMessage;
        this.entry = entry;
    }

    public SaveException(Exception base) {
        this(base.getMessage(), base.getLocalizedMessage());
    }

    public SaveException(Exception base, BibEntry entry) {
        this(base.getMessage(), base.getLocalizedMessage(), entry);
    }

    public int getStatus() {
        return this.status;
    }

    public BibEntry getEntry() {
        return this.entry;
    }

    public boolean specificEntry() {
        return this.entry != null;
    }

    @Override
    public String getLocalizedMessage() {
        if (this.localizedMessage == null) {
            return this.getMessage();
        }
        return this.localizedMessage;
    }
}

