/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.exporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jabref.logic.bibtex.comparator.FieldComparator;
import net.sf.jabref.logic.bibtex.comparator.FieldComparatorStack;
import net.sf.jabref.logic.layout.format.GetOpenOfficeType;
import net.sf.jabref.logic.layout.format.RemoveBrackets;
import net.sf.jabref.logic.layout.format.RemoveWhitespace;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

class OpenDocumentRepresentation {
    private final List<BibEntry> entries;
    private final BibDatabase database;
    private static final Log LOGGER = LogFactory.getLog(OpenDocumentRepresentation.class);

    public OpenDocumentRepresentation(BibDatabase database, List<BibEntry> entries) {
        this.database = database;
        ArrayList<FieldComparator> comparators = new ArrayList<FieldComparator>();
        comparators.add(new FieldComparator("author"));
        comparators.add(new FieldComparator("year"));
        comparators.add(new FieldComparator("bibtexkey"));
        ArrayList<BibEntry> entryList = new ArrayList<BibEntry>();
        if (entries == null) {
            entryList.addAll(database.getEntries());
        } else {
            entryList.addAll(entries);
        }
        Collections.sort(entryList, new FieldComparatorStack(comparators));
        this.entries = entryList;
    }

    public Document getDOMrepresentation() {
        Document result = null;
        try {
            DocumentBuilder dbuild = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            result = dbuild.newDocument();
            Element collection = result.createElement("office:document-content");
            collection.setAttribute("xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
            collection.setAttribute("xmlns:style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            collection.setAttribute("xmlns:text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
            collection.setAttribute("xmlns:table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
            collection.setAttribute("xmlns:meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
            collection.setAttribute("office:version", "1.0");
            collection.setAttribute("xmlns:fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
            collection.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
            Element el = result.createElement("office:scripts");
            collection.appendChild(el);
            el = result.createElement("office:automatic-styles");
            Element el2 = result.createElement("style:style");
            el2.setAttribute("style:name", "ro1");
            el2.setAttribute("style:family", "table-row");
            Element el3 = result.createElement("style.table-row-properties");
            el3.setAttribute("style:row-height", "0.1681inch");
            el3.setAttribute("fo:break-before", "auto");
            el3.setAttribute("style:use-optimal-row-height", "true");
            el2.appendChild(el3);
            el.appendChild(el2);
            el2 = result.createElement("style:style");
            el2.setAttribute("style:name", "ta1");
            el2.setAttribute("style:family", "table");
            el2.setAttribute("style:master-page-name", "Default");
            el3 = result.createElement("style:properties");
            el3.setAttribute("table:display", "true");
            el2.appendChild(el3);
            el.appendChild(el2);
            collection.appendChild(el);
            Element body = result.createElement("office:body");
            Element spreadsheet = result.createElement("office:spreadsheet");
            Element table = result.createElement("table:table");
            table.setAttribute("table:name", "biblio");
            table.setAttribute("table.style-name", "ta1");
            Element row = result.createElement("table:table-row");
            row.setAttribute("table.style-name", "ro1");
            this.addTableCell(result, row, "Identifier");
            this.addTableCell(result, row, "Type");
            this.addTableCell(result, row, "Address");
            this.addTableCell(result, row, "Assignee");
            this.addTableCell(result, row, "Annote");
            this.addTableCell(result, row, "Author");
            this.addTableCell(result, row, "Booktitle");
            this.addTableCell(result, row, "Chapter");
            this.addTableCell(result, row, "Day");
            this.addTableCell(result, row, "Dayfiled");
            this.addTableCell(result, row, "Edition");
            this.addTableCell(result, row, "Editor");
            this.addTableCell(result, row, "Howpublish");
            this.addTableCell(result, row, "Institution");
            this.addTableCell(result, row, "Journal");
            this.addTableCell(result, row, "Language");
            this.addTableCell(result, row, "Month");
            this.addTableCell(result, row, "Monthfiled");
            this.addTableCell(result, row, "Nationality");
            this.addTableCell(result, row, "Note");
            this.addTableCell(result, row, "Number");
            this.addTableCell(result, row, "Organization");
            this.addTableCell(result, row, "Pages");
            this.addTableCell(result, row, "Publisher");
            this.addTableCell(result, row, "Revision");
            this.addTableCell(result, row, "School");
            this.addTableCell(result, row, "Series");
            this.addTableCell(result, row, "Title");
            this.addTableCell(result, row, "RepType");
            this.addTableCell(result, row, "Volume");
            this.addTableCell(result, row, "Year");
            this.addTableCell(result, row, "Yearfiled");
            this.addTableCell(result, row, "URL");
            this.addTableCell(result, row, "Custom1");
            this.addTableCell(result, row, "Custom2");
            this.addTableCell(result, row, "Custom3");
            this.addTableCell(result, row, "Custom4");
            this.addTableCell(result, row, "Custom5");
            this.addTableCell(result, row, "ISBN");
            table.appendChild(row);
            for (BibEntry e : this.entries) {
                row = result.createElement("table:table-row");
                this.addTableCell(result, row, this.getField(e, "bibtexkey"));
                this.addTableCell(result, row, new GetOpenOfficeType().format(e.getType()));
                this.addTableCell(result, row, this.getField(e, "address"));
                this.addTableCell(result, row, this.getField(e, "assignee"));
                this.addTableCell(result, row, this.getField(e, "annote"));
                this.addTableCell(result, row, this.getField(e, "author"));
                this.addTableCell(result, row, this.getField(e, "booktitle"));
                this.addTableCell(result, row, this.getField(e, "chapter"));
                this.addTableCell(result, row, this.getField(e, "day"));
                this.addTableCell(result, row, this.getField(e, "dayfiled"));
                this.addTableCell(result, row, this.getField(e, "edition"));
                this.addTableCell(result, row, this.getField(e, "editor"));
                this.addTableCell(result, row, this.getField(e, "howpublished"));
                this.addTableCell(result, row, this.getField(e, "institution"));
                this.addTableCell(result, row, this.getField(e, "journal"));
                this.addTableCell(result, row, this.getField(e, "language"));
                this.addTableCell(result, row, this.getField(e, "month"));
                this.addTableCell(result, row, this.getField(e, "monthfiled"));
                this.addTableCell(result, row, this.getField(e, "nationality"));
                this.addTableCell(result, row, this.getField(e, "note"));
                this.addTableCell(result, row, this.getField(e, "number"));
                this.addTableCell(result, row, this.getField(e, "organization"));
                this.addTableCell(result, row, this.getField(e, "pages"));
                this.addTableCell(result, row, this.getField(e, "publisher"));
                this.addTableCell(result, row, this.getField(e, "revision"));
                this.addTableCell(result, row, this.getField(e, "school"));
                this.addTableCell(result, row, this.getField(e, "series"));
                this.addTableCell(result, row, new RemoveWhitespace().format(new RemoveBrackets().format(this.getField(e, "title"))));
                this.addTableCell(result, row, this.getField(e, "reporttype"));
                this.addTableCell(result, row, this.getField(e, "volume"));
                this.addTableCell(result, row, this.getField(e, "year"));
                this.addTableCell(result, row, this.getField(e, "yearfiled"));
                this.addTableCell(result, row, this.getField(e, "url"));
                this.addTableCell(result, row, "");
                this.addTableCell(result, row, "");
                this.addTableCell(result, row, "");
                this.addTableCell(result, row, "");
                this.addTableCell(result, row, "");
                this.addTableCell(result, row, this.getField(e, "isbn"));
                table.appendChild(row);
            }
            spreadsheet.appendChild(table);
            body.appendChild(spreadsheet);
            collection.appendChild(body);
            result.appendChild(collection);
        }
        catch (Exception e) {
            LOGGER.warn("Exception caught...", e);
        }
        return result;
    }

    private String getField(BibEntry e, String field) {
        return BibDatabase.getResolvedField(field, e, this.database).orElse("");
    }

    private void addTableCell(Document doc, Element parent, String content) {
        Element cell = doc.createElement("table:table-cell");
        Element text = doc.createElement("text:p");
        Text textNode = doc.createTextNode(content);
        text.appendChild(textNode);
        cell.appendChild(text);
        parent.appendChild(cell);
    }
}

