/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.exporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.model.bibtexkeypattern.AbstractBibtexKeyPattern;
import net.sf.jabref.model.bibtexkeypattern.GlobalBibtexKeyPattern;
import net.sf.jabref.model.groups.GroupTreeNode;
import net.sf.jabref.model.metadata.MetaData;
import net.sf.jabref.model.strings.StringUtil;

public class MetaDataSerializer {
    public static Map<String, String> getSerializedStringMap(MetaData metaData, GlobalBibtexKeyPattern globalCiteKeyPattern) {
        HashMap<String, List<String>> stringyMetaData = new HashMap<String, List<String>>();
        metaData.getSaveOrderConfig().ifPresent(saveOrderConfig -> stringyMetaData.put("saveOrderConfig", saveOrderConfig.getAsStringList()));
        metaData.getSaveActions().ifPresent(saveActions -> stringyMetaData.put("saveActions", saveActions.getAsStringList(OS.NEWLINE)));
        if (metaData.isProtected()) {
            stringyMetaData.put("protectedFlag", Collections.singletonList("true"));
        }
        stringyMetaData.putAll(MetaDataSerializer.serializeCiteKeyPattern(metaData, globalCiteKeyPattern));
        metaData.getMode().ifPresent(mode -> stringyMetaData.put("databaseType", Collections.singletonList(mode.getAsString())));
        metaData.getDefaultFileDirectory().ifPresent(path -> stringyMetaData.put("fileDirectory", Collections.singletonList(path.trim())));
        metaData.getUserFileDirectories().forEach((user, path) -> stringyMetaData.put("fileDirectory-" + user, Collections.singletonList(path.trim())));
        Map<String, String> serializedMetaData = MetaDataSerializer.serializeMetaData(stringyMetaData);
        metaData.getGroups().filter(root -> root.getNumberOfChildren() > 0).ifPresent(root -> serializedMetaData.put("groupstree", MetaDataSerializer.serializeGroups(root)));
        return serializedMetaData;
    }

    private static Map<String, String> serializeMetaData(Map<String, List<String>> stringyMetaData) {
        TreeMap<String, String> serializedMetaData = new TreeMap<String, String>();
        for (Map.Entry<String, List<String>> metaItem : stringyMetaData.entrySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String dataItem : metaItem.getValue()) {
                stringBuilder.append(StringUtil.quote(dataItem, MetaData.SEPARATOR_STRING, '\\')).append(MetaData.SEPARATOR_STRING);
                if (!metaItem.getKey().equals("saveActions") || !"enabled".equals(dataItem) && !"disabled".equals(dataItem)) continue;
                stringBuilder.append(OS.NEWLINE);
            }
            String serializedItem = stringBuilder.toString();
            if (serializedItem.isEmpty() || MetaData.SEPARATOR_STRING.equals(serializedItem)) continue;
            serializedMetaData.put(metaItem.getKey(), serializedItem);
        }
        return serializedMetaData;
    }

    private static Map<String, List<String>> serializeCiteKeyPattern(MetaData metaData, GlobalBibtexKeyPattern globalCiteKeyPattern) {
        HashMap<String, List<String>> stringyPattern = new HashMap<String, List<String>>();
        AbstractBibtexKeyPattern citeKeyPattern = metaData.getCiteKeyPattern(globalCiteKeyPattern);
        for (String key : citeKeyPattern.getAllKeys()) {
            if (citeKeyPattern.isDefaultValue(key)) continue;
            ArrayList<String> data = new ArrayList<String>();
            data.add(citeKeyPattern.getValue(key).get(0));
            String metaDataKey = "keypattern_" + key;
            stringyPattern.put(metaDataKey, data);
        }
        if (citeKeyPattern.getDefaultValue() != null && !citeKeyPattern.getDefaultValue().isEmpty()) {
            ArrayList<String> data = new ArrayList<String>();
            data.add(citeKeyPattern.getDefaultValue().get(0));
            stringyPattern.put("keypatterndefault", data);
        }
        return stringyPattern;
    }

    private static String serializeGroups(GroupTreeNode root) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(OS.NEWLINE);
        for (String groupNode : root.getTreeAsString()) {
            stringBuilder.append(StringUtil.quote(groupNode, MetaData.SEPARATOR_STRING, '\\'));
            stringBuilder.append(MetaData.SEPARATOR_STRING);
            stringBuilder.append(OS.NEWLINE);
        }
        return stringBuilder.toString();
    }
}

