/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.exporter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.sf.jabref.logic.exporter.SaveException;
import net.sf.jabref.logic.exporter.SaveSession;
import net.sf.jabref.logic.exporter.VerifyingWriter;
import net.sf.jabref.logic.util.io.FileBasedLock;
import net.sf.jabref.logic.util.io.FileUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSaveSession
extends SaveSession {
    private static final Log LOGGER = LogFactory.getLog(FileSaveSession.class);
    private static final String BACKUP_EXTENSION = ".bak";
    private static final String TEMP_PREFIX = "jabref";
    private static final String TEMP_SUFFIX = "save.bib";
    private final Path temporaryFile;

    public FileSaveSession(Charset encoding, boolean backup) throws SaveException {
        this(encoding, backup, FileSaveSession.createTemporaryFile());
    }

    public FileSaveSession(Charset encoding, boolean backup, Path temporaryFile) throws SaveException {
        super(encoding, backup, FileSaveSession.getWriterForFile(encoding, temporaryFile));
        this.temporaryFile = temporaryFile;
    }

    private static VerifyingWriter getWriterForFile(Charset encoding, Path file) throws SaveException {
        try {
            return new VerifyingWriter(Files.newOutputStream(file, new OpenOption[0]), encoding);
        }
        catch (IOException e) {
            throw new SaveException(e);
        }
    }

    private static Path createTemporaryFile() throws SaveException {
        try {
            return Files.createTempFile(TEMP_PREFIX, TEMP_SUFFIX, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SaveException(e);
        }
    }

    @Override
    public void commit(Path file) throws SaveException {
        if (file == null) {
            return;
        }
        if (this.backup && Files.exists(file, new LinkOption[0])) {
            Path backupFile = FileUtil.addExtension(file, BACKUP_EXTENSION);
            FileUtil.copyFile(file, backupFile, true);
        }
        try {
            try {
                if (FileBasedLock.createLockFile(file) && !FileBasedLock.waitForFileLock(file)) {
                    throw SaveException.FILE_LOCKED;
                }
            }
            catch (IOException ex) {
                LOGGER.error("Error when creating lock file.", ex);
            }
            FileUtil.copyFile(this.temporaryFile, file, true);
        }
        finally {
            FileBasedLock.deleteLockFile(file);
        }
        try {
            Files.deleteIfExists(this.temporaryFile);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot delete temporary file", e);
        }
    }

    @Override
    public void cancel() {
        try {
            Files.deleteIfExists(this.temporaryFile);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot delete temporary file", e);
        }
    }
}

