/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.exporter;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.sf.jabref.logic.exporter.BibTeXMLExportFormat;
import net.sf.jabref.logic.exporter.ExportFormat;
import net.sf.jabref.logic.exporter.IExportFormat;
import net.sf.jabref.logic.exporter.MSBibExportFormat;
import net.sf.jabref.logic.exporter.ModsExportFormat;
import net.sf.jabref.logic.exporter.OpenDocumentSpreadsheetCreator;
import net.sf.jabref.logic.exporter.OpenOfficeDocumentCreator;
import net.sf.jabref.logic.exporter.SavePreferences;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.layout.LayoutFormatterPreferences;

public class ExportFormats {
    private static final Map<String, IExportFormat> EXPORT_FORMATS = new TreeMap<String, IExportFormat>();
    public static int entryNumber;

    public static void initAllExports(Map<String, ExportFormat> customFormats, LayoutFormatterPreferences layoutPreferences, SavePreferences savePreferences) {
        EXPORT_FORMATS.clear();
        ExportFormats.putFormat(new ExportFormat("HTML", "html", "html", null, ".html", layoutPreferences, savePreferences));
        ExportFormats.putFormat(new ExportFormat(Localization.lang("Simple HTML", new String[0]), "simplehtml", "simplehtml", null, ".html", layoutPreferences, savePreferences));
        ExportFormats.putFormat(new ExportFormat("DocBook 4.4", "docbook", "docbook", null, ".xml", layoutPreferences, savePreferences));
        ExportFormats.putFormat(new ExportFormat("DIN 1505", "din1505", "din1505winword", "din1505", ".rtf", layoutPreferences, savePreferences));
        ExportFormats.putFormat(new ExportFormat("BibO RDF", "bibordf", "bibordf", null, ".rdf", layoutPreferences, savePreferences));
        ExportFormats.putFormat(new ExportFormat(Localization.lang("HTML table", new String[0]), "tablerefs", "tablerefs", "tablerefs", ".html", layoutPreferences, savePreferences));
        ExportFormats.putFormat(new ExportFormat(Localization.lang("HTML list", new String[0]), "listrefs", "listrefs", "listrefs", ".html", layoutPreferences, savePreferences));
        ExportFormats.putFormat(new ExportFormat(Localization.lang("HTML table (with Abstract & BibTeX)", new String[0]), "tablerefsabsbib", "tablerefsabsbib", "tablerefsabsbib", ".html", layoutPreferences, savePreferences));
        ExportFormats.putFormat(new ExportFormat("Harvard RTF", "harvard", "harvard", "harvard", ".rtf", layoutPreferences, savePreferences));
        ExportFormats.putFormat(new ExportFormat("ISO 690 RTF", "iso690rtf", "iso690RTF", "iso690rtf", ".rtf", layoutPreferences, savePreferences));
        ExportFormats.putFormat(new ExportFormat("ISO 690", "iso690txt", "iso690", "iso690txt", ".txt", layoutPreferences, savePreferences));
        ExportFormats.putFormat(new ExportFormat("Endnote", "endnote", "EndNote", "endnote", ".txt", layoutPreferences, savePreferences));
        ExportFormats.putFormat(new ExportFormat("OpenOffice/LibreOffice CSV", "oocsv", "openoffice-csv", "openoffice", ".csv", layoutPreferences, savePreferences));
        ExportFormat ef = new ExportFormat("RIS", "ris", "ris", "ris", ".ris", layoutPreferences, savePreferences);
        ef.setEncoding(StandardCharsets.UTF_8);
        ExportFormats.putFormat(ef);
        ExportFormats.putFormat(new ExportFormat("MIS Quarterly", "misq", "misq", "misq", ".rtf", layoutPreferences, savePreferences));
        ExportFormats.putFormat(new BibTeXMLExportFormat());
        ExportFormats.putFormat(new OpenOfficeDocumentCreator());
        ExportFormats.putFormat(new OpenDocumentSpreadsheetCreator());
        ExportFormats.putFormat(new MSBibExportFormat());
        ExportFormats.putFormat(new ModsExportFormat());
        for (IExportFormat iExportFormat : customFormats.values()) {
            ExportFormats.putFormat(iExportFormat);
        }
    }

    public static String getConsoleExportList(int maxLineLength, int firstLineSubtr, String linePrefix) {
        StringBuilder sb = new StringBuilder();
        int lastBreak = -firstLineSubtr;
        for (String name : EXPORT_FORMATS.keySet()) {
            if (sb.length() + 2 + name.length() - lastBreak > maxLineLength) {
                sb.append(",\n");
                lastBreak = sb.length();
                sb.append(linePrefix);
            } else if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(name);
        }
        return sb.toString();
    }

    public static Map<String, IExportFormat> getExportFormats() {
        return Collections.unmodifiableMap(EXPORT_FORMATS);
    }

    public static IExportFormat getExportFormat(String consoleName) {
        return EXPORT_FORMATS.get(consoleName);
    }

    private static void putFormat(IExportFormat format) {
        EXPORT_FORMATS.put(format.getConsoleName(), format);
    }
}

