/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.exporter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.sf.jabref.JabRefMain;
import net.sf.jabref.logic.exporter.BibDatabaseWriter;
import net.sf.jabref.logic.exporter.ExportFormats;
import net.sf.jabref.logic.exporter.FileSaveSession;
import net.sf.jabref.logic.exporter.IExportFormat;
import net.sf.jabref.logic.exporter.SaveException;
import net.sf.jabref.logic.exporter.SavePreferences;
import net.sf.jabref.logic.exporter.SaveSession;
import net.sf.jabref.logic.exporter.VerifyingWriter;
import net.sf.jabref.logic.layout.Layout;
import net.sf.jabref.logic.layout.LayoutFormatterPreferences;
import net.sf.jabref.logic.layout.LayoutHelper;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportFormat
implements IExportFormat {
    private String displayName;
    private String consoleName;
    private String lfFileName;
    private String directory;
    private String extension;
    private Charset encoding;
    private LayoutFormatterPreferences layoutPreferences;
    private SavePreferences savePreferences;
    private boolean customExport;
    private static final String LAYOUT_PREFIX = "/resource/layout/";
    private static final Log LOGGER = LogFactory.getLog(ExportFormat.class);

    public ExportFormat(String displayName, String consoleName, String lfFileName, String directory, String extension) {
        this.displayName = displayName;
        this.consoleName = consoleName;
        this.lfFileName = lfFileName;
        this.directory = directory;
        this.extension = extension;
    }

    public ExportFormat(String displayName, String consoleName, String lfFileName, String directory, String extension, LayoutFormatterPreferences layoutPreferences, SavePreferences savePreferences) {
        this(displayName, consoleName, lfFileName, directory, extension);
        this.layoutPreferences = layoutPreferences;
        this.savePreferences = savePreferences;
    }

    protected ExportFormat() {
    }

    public void setCustomExport(boolean custom) {
        this.customExport = custom;
    }

    @Override
    public String getConsoleName() {
        return this.consoleName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    private Reader getReader(String filename) throws IOException {
        InputStreamReader reader;
        String dir = this.customExport ? "" : LAYOUT_PREFIX + (this.directory == null ? "" : this.directory + '/');
        String name = dir + filename;
        URL reso = JabRefMain.class.getResource(name);
        try {
            if (reso == null) {
                File f = new File(name);
                reader = new FileReader(f);
            } else {
                reader = new InputStreamReader(reso.openStream());
            }
        }
        catch (FileNotFoundException ex) {
            throw new IOException("Cannot find layout file: '" + name + "'.");
        }
        return reader;
    }

    @Override
    public void performExport(BibDatabaseContext databaseContext, String file, Charset encoding, List<BibEntry> entries) throws Exception {
        Objects.requireNonNull(databaseContext);
        Objects.requireNonNull(entries);
        if (entries.isEmpty()) {
            return;
        }
        Path outFile = Paths.get(file, new String[0]);
        SaveSession ss = null;
        if (this.encoding != null) {
            try {
                ss = new FileSaveSession(this.encoding, false);
            }
            catch (SaveException ex) {
                LOGGER.warn("Can not get save session.", ex);
            }
        }
        if (ss == null) {
            ss = new FileSaveSession(encoding, false);
        }
        try (VerifyingWriter ps = ss.getWriter();){
            Layout defLayout;
            LayoutHelper layoutHelper;
            Layout beginLayout = null;
            this.readFormatterFile();
            ArrayList<String> missingFormatters = new ArrayList<String>(1);
            try (Reader reader2 = this.getReader(this.lfFileName + ".begin.layout");){
                layoutHelper = new LayoutHelper(reader2, this.layoutPreferences);
                beginLayout = layoutHelper.getLayoutFromText();
            }
            catch (IOException reader2) {
                // empty catch block
            }
            if (beginLayout != null) {
                ps.write(beginLayout.doLayout(databaseContext, encoding));
                missingFormatters.addAll(beginLayout.getMissingFormatters());
            }
            List<BibEntry> sorted = BibDatabaseWriter.getSortedEntries(databaseContext, entries, this.savePreferences);
            try (Reader reader = this.getReader(this.lfFileName + ".layout");){
                layoutHelper = new LayoutHelper(reader, this.layoutPreferences);
                defLayout = layoutHelper.getLayoutFromText();
            }
            if (defLayout != null) {
                missingFormatters.addAll(defLayout.getMissingFormatters());
                if (!missingFormatters.isEmpty()) {
                    LOGGER.warn(missingFormatters);
                }
            }
            HashMap<String, Layout> layouts = new HashMap<String, Layout>();
            ExportFormats.entryNumber = 0;
            for (BibEntry entry : sorted) {
                Layout layout;
                ++ExportFormats.entryNumber;
                String type = entry.getType();
                if (layouts.containsKey(type)) {
                    layout = (Layout)layouts.get(type);
                } else {
                    try (Reader reader = this.getReader(this.lfFileName + '.' + type + ".layout");){
                        layoutHelper = new LayoutHelper(reader, this.layoutPreferences);
                        layout = layoutHelper.getLayoutFromText();
                        layouts.put(type, layout);
                        if (layout != null) {
                            missingFormatters.addAll(layout.getMissingFormatters());
                        }
                    }
                    catch (IOException ex) {
                        layout = defLayout;
                    }
                }
                if (layout == null) continue;
                ps.write(layout.doLayout(entry, databaseContext.getDatabase()));
            }
            Layout endLayout = null;
            try (Reader reader3 = this.getReader(this.lfFileName + ".end.layout");){
                layoutHelper = new LayoutHelper(reader3, this.layoutPreferences);
                endLayout = layoutHelper.getLayoutFromText();
            }
            catch (IOException reader3) {
                // empty catch block
            }
            if (endLayout != null) {
                ps.write(endLayout.doLayout(databaseContext, this.encoding));
                missingFormatters.addAll(endLayout.getMissingFormatters());
            }
            this.layoutPreferences.clearCustomExportNameFormatters();
            if (!missingFormatters.isEmpty()) {
                StringBuilder sb = new StringBuilder("The following formatters could not be found: ");
                sb.append(String.join((CharSequence)", ", missingFormatters));
                LOGGER.warn(sb);
            }
            this.finalizeSaveSession(ss, outFile);
        }
    }

    @Override
    public void performExport(BibDatabaseContext databaseContext, Path file, Charset encoding, List<BibEntry> entries) throws Exception {
        this.performExport(databaseContext, file.getFileName().toString(), encoding, entries);
    }

    private void readFormatterFile() {
        File formatterFile = new File(this.lfFileName + ".formatters");
        if (formatterFile.exists()) {
            try (FileReader in = new FileReader(formatterFile);){
                String[] lines;
                int c;
                StringBuilder sb = new StringBuilder();
                while ((c = ((Reader)in).read()) != -1) {
                    sb.append((char)c);
                }
                for (String line1 : lines = sb.toString().split("\n")) {
                    int index;
                    String line = line1.trim();
                    if (line.isEmpty() || (index = line.indexOf(58)) <= 0 || index + 1 >= line.length()) continue;
                    String formatterName = line.substring(0, index);
                    String contents = line.substring(index + 1);
                    this.layoutPreferences.putCustomExportNameFormatter(formatterName, contents);
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Problem opening formatter file.", ex);
            }
        }
    }

    public void finalizeSaveSession(SaveSession ss, Path file) throws SaveException, IOException {
        ss.getWriter().flush();
        ss.getWriter().close();
        if (!ss.getWriter().couldEncodeAll()) {
            LOGGER.warn("Could not encode...");
        }
        ss.commit(file);
    }
}

