/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.exporter;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import net.sf.jabref.logic.exporter.ExportFormat;
import net.sf.jabref.logic.exporter.SavePreferences;
import net.sf.jabref.logic.journals.JournalAbbreviationLoader;
import net.sf.jabref.logic.layout.LayoutFormatterPreferences;
import net.sf.jabref.preferences.JabRefPreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomExportList {
    private final EventList<List<String>> list;
    private final SortedList<List<String>> sorted;
    private final Map<String, ExportFormat> formats = new TreeMap<String, ExportFormat>();
    private static final Log LOGGER = LogFactory.getLog(CustomExportList.class);

    public CustomExportList(Comparator<List<String>> comp) {
        this.list = new BasicEventList<List<String>>();
        this.sorted = new SortedList<List<String>>(this.list, comp);
    }

    public Map<String, ExportFormat> getCustomExportFormats(JabRefPreferences prefs, JournalAbbreviationLoader loader) {
        Objects.requireNonNull(prefs);
        Objects.requireNonNull(loader);
        this.formats.clear();
        this.readPrefs(prefs, loader);
        return this.formats;
    }

    public int size() {
        return this.list.size();
    }

    public EventList<List<String>> getSortedList() {
        return this.sorted;
    }

    private void readPrefs(JabRefPreferences prefs, JournalAbbreviationLoader loader) {
        List<String> s;
        Objects.requireNonNull(prefs);
        Objects.requireNonNull(loader);
        this.formats.clear();
        this.list.clear();
        int i = 0;
        LayoutFormatterPreferences layoutPreferences = prefs.getLayoutFormatterPreferences(loader);
        SavePreferences savePreferences = SavePreferences.loadForExportFromPreferences(prefs);
        while (!(s = prefs.getStringList("customExportFormat" + i)).isEmpty()) {
            Optional<ExportFormat> format = this.createFormat(s, layoutPreferences, savePreferences);
            if (format.isPresent()) {
                this.formats.put(format.get().getConsoleName(), format.get());
                this.list.add(s);
            } else {
                String customExportFormat = prefs.get("customExportFormat" + i);
                LOGGER.error("Error initializing custom export format from string " + customExportFormat);
            }
            ++i;
        }
    }

    private Optional<ExportFormat> createFormat(List<String> s, LayoutFormatterPreferences layoutPreferences, SavePreferences savePreferences) {
        if (s.size() < 3) {
            return Optional.empty();
        }
        String lfFileName = s.get(1).endsWith(".layout") ? s.get(1).substring(0, s.get(1).length() - 7) : s.get(1);
        ExportFormat format = new ExportFormat(s.get(0), s.get(0), lfFileName, null, s.get(2), layoutPreferences, savePreferences);
        format.setCustomExport(true);
        return Optional.of(format);
    }

    public void addFormat(List<String> s, LayoutFormatterPreferences layoutPreferences, SavePreferences savePreferences) {
        this.createFormat(s, layoutPreferences, savePreferences).ifPresent(format -> {
            this.formats.put(format.getConsoleName(), (ExportFormat)format);
            this.list.add(s);
        });
    }

    public void remove(List<String> toRemove, LayoutFormatterPreferences layoutPreferences, SavePreferences savePreferences) {
        this.createFormat(toRemove, layoutPreferences, savePreferences).ifPresent(format -> {
            this.formats.remove(format.getConsoleName());
            this.list.remove(toRemove);
        });
    }

    public void store(JabRefPreferences prefs) {
        if (this.list.isEmpty()) {
            this.purge(0, prefs);
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                prefs.putStringList("customExportFormat" + i, (List)this.list.get(i));
            }
            this.purge(this.list.size(), prefs);
        }
    }

    private void purge(int from, JabRefPreferences prefs) {
        int i = from;
        while (!prefs.getStringList("customExportFormat" + i).isEmpty()) {
            prefs.remove("customExportFormat" + i);
            ++i;
        }
    }
}

