/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.exporter;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import net.sf.jabref.logic.bibtex.BibEntryWriter;
import net.sf.jabref.logic.bibtex.LatexFieldFormatter;
import net.sf.jabref.logic.bibtex.LatexFieldFormatterPreferences;
import net.sf.jabref.logic.exporter.BibDatabaseWriter;
import net.sf.jabref.logic.exporter.SaveException;
import net.sf.jabref.logic.exporter.SaveSession;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.BibtexString;
import net.sf.jabref.model.entry.CustomEntryType;
import net.sf.jabref.model.strings.StringUtil;

public class BibtexDatabaseWriter<E extends SaveSession>
extends BibDatabaseWriter<E> {
    private static final String STRING_PREFIX = "@String";
    private static final String COMMENT_PREFIX = "@Comment";
    private static final String PREAMBLE_PREFIX = "@Preamble";
    public static final String DATABASE_ID_PREFIX = "DBID:";

    public BibtexDatabaseWriter(BibDatabaseWriter.SaveSessionFactory<E> saveSessionFactory) {
        super(saveSessionFactory);
    }

    @Override
    protected void writeEpilogue(String epilogue) throws SaveException {
        if (!StringUtil.isNullOrEmpty(epilogue)) {
            try {
                this.getWriter().write(OS.NEWLINE);
                this.getWriter().write(epilogue);
                this.getWriter().write(OS.NEWLINE);
            }
            catch (IOException e) {
                throw new SaveException(e);
            }
        }
    }

    @Override
    protected void writeMetaDataItem(Map.Entry<String, String> metaItem) throws SaveException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(OS.NEWLINE);
        stringBuilder.append("@Comment{").append("jabref-meta: ").append(metaItem.getKey()).append(":");
        stringBuilder.append(metaItem.getValue());
        stringBuilder.append("}");
        stringBuilder.append(OS.NEWLINE);
        try {
            this.getWriter().write(stringBuilder.toString());
        }
        catch (IOException e) {
            throw new SaveException(e);
        }
    }

    @Override
    protected void writePreamble(String preamble) throws SaveException {
        if (!StringUtil.isNullOrEmpty(preamble)) {
            try {
                this.getWriter().write(OS.NEWLINE);
                this.getWriter().write("@Preamble{");
                this.getWriter().write(preamble);
                this.getWriter().write('}' + OS.NEWLINE);
            }
            catch (IOException e) {
                throw new SaveException(e);
            }
        }
    }

    @Override
    protected void writeString(BibtexString bibtexString, boolean isFirstString, int maxKeyLength, Boolean reformatFile, LatexFieldFormatterPreferences latexFieldFormatterPreferences) throws SaveException {
        try {
            if (!reformatFile.booleanValue() && !bibtexString.hasChanged()) {
                this.getWriter().write(bibtexString.getParsedSerialization());
                return;
            }
            String userComments = bibtexString.getUserComments();
            if (!userComments.isEmpty()) {
                this.getWriter().write(userComments + OS.NEWLINE);
            }
            if (isFirstString) {
                this.getWriter().write(OS.NEWLINE);
            }
            this.getWriter().write("@String{" + bibtexString.getName() + StringUtil.repeatSpaces(maxKeyLength - bibtexString.getName().length()) + " = ");
            if (bibtexString.getContent().isEmpty()) {
                this.getWriter().write("{}");
            } else {
                try {
                    String formatted = new LatexFieldFormatter(latexFieldFormatterPreferences).format(bibtexString.getContent(), "__string");
                    this.getWriter().write(formatted);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("The # character is not allowed in BibTeX strings unless escaped as in '\\#'.\nBefore saving, please edit any strings containing the # character.");
                }
            }
            this.getWriter().write("}" + OS.NEWLINE);
        }
        catch (IOException e) {
            throw new SaveException(e);
        }
    }

    @Override
    protected void writeEntryTypeDefinition(CustomEntryType customType) throws SaveException {
        try {
            this.getWriter().write(OS.NEWLINE);
            this.getWriter().write("@Comment{");
            this.getWriter().write(customType.getAsString());
            this.getWriter().write("}");
            this.getWriter().write(OS.NEWLINE);
        }
        catch (IOException e) {
            throw new SaveException(e);
        }
    }

    @Override
    protected void writePrelogue(BibDatabaseContext bibDatabaseContext, Charset encoding) throws SaveException {
        if (encoding == null) {
            return;
        }
        try {
            this.getWriter().write("% ");
            this.getWriter().write("Encoding: " + encoding);
            this.getWriter().write(OS.NEWLINE);
        }
        catch (IOException e) {
            throw new SaveException(e);
        }
    }

    @Override
    protected void writeDatabaseID(String sharedDatabaseID) throws SaveException {
        try {
            StringBuilder stringBuilder = new StringBuilder().append("% ").append(DATABASE_ID_PREFIX).append(" ").append(sharedDatabaseID).append(OS.NEWLINE);
            this.getWriter().write(stringBuilder.toString());
        }
        catch (IOException e) {
            throw new SaveException(e);
        }
    }

    @Override
    protected void writeEntry(BibEntry entry, BibDatabaseMode mode, Boolean isReformatFile, LatexFieldFormatterPreferences latexFieldFormatterPreferences) throws SaveException {
        BibEntryWriter bibtexEntryWriter = new BibEntryWriter(new LatexFieldFormatter(latexFieldFormatterPreferences), true);
        try {
            bibtexEntryWriter.write(entry, this.getWriter(), mode, isReformatFile);
        }
        catch (IOException e) {
            throw new SaveException(e, entry);
        }
    }

    private Writer getWriter() {
        return this.getActiveSession().getWriter();
    }
}

