/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.error;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.sf.jabref.logic.error.TeeStream;

public class StreamEavesdropper {
    private final ByteArrayOutputStream errByteStream = new ByteArrayOutputStream();
    private final ByteArrayOutputStream outByteStream = new ByteArrayOutputStream();
    private final PrintStream systemOut;
    private final PrintStream systemErr;

    public static StreamEavesdropper eavesdropOnSystem() {
        StreamEavesdropper streamEavesdropper = new StreamEavesdropper(System.out, System.err);
        System.setOut(streamEavesdropper.getOutStream());
        System.setErr(streamEavesdropper.getErrStream());
        return streamEavesdropper;
    }

    public StreamEavesdropper(PrintStream systemOut, PrintStream systemErr) {
        this.systemOut = systemOut;
        this.systemErr = systemErr;
    }

    public PrintStream getOutStream() {
        PrintStream consoleOut = new PrintStream(this.outByteStream);
        return new TeeStream(consoleOut, this.systemOut);
    }

    public PrintStream getErrStream() {
        PrintStream consoleErr = new PrintStream(this.errByteStream);
        return new TeeStream(consoleErr, this.systemErr);
    }

    public String getErrorMessages() {
        return this.errByteStream.toString();
    }

    public String getOutput() {
        return this.outByteStream.toString();
    }
}

