/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.cleanup;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.cleanup.CleanupJob;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.FileField;
import net.sf.jabref.model.entry.ParsedFileField;

public class UpgradePdfPsToFileCleanup
implements CleanupJob {
    private final Map<String, String> fields = new HashMap<String, String>();

    public UpgradePdfPsToFileCleanup() {
        this.fields.put("pdf", "PDF");
        this.fields.put("ps", "PostScript");
    }

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        String oldFileContent = entry.getField("file").orElse(null);
        ArrayList<ParsedFileField> fileList = new ArrayList<ParsedFileField>(FileField.parse(oldFileContent));
        int oldItemCount = fileList.size();
        for (Map.Entry<String, String> field : this.fields.entrySet()) {
            entry.getField(field.getKey()).ifPresent(o -> {
                if (o.trim().isEmpty()) {
                    return;
                }
                File f = new File((String)o);
                ParsedFileField flEntry = new ParsedFileField(f.getName(), (String)o, (String)field.getValue());
                fileList.add(flEntry);
                entry.clearField((String)field.getKey());
                changes.add(new FieldChange(entry, (String)field.getKey(), (String)o, null));
            });
        }
        if (fileList.size() != oldItemCount) {
            String newValue = FileField.getStringRepresentation(fileList);
            entry.setField("file", newValue);
            changes.add(new FieldChange(entry, "file", oldFileContent, newValue));
        }
        return changes;
    }
}

