/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.cleanup;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.sf.jabref.logic.TypedBibEntry;
import net.sf.jabref.logic.layout.LayoutFormatterPreferences;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.cleanup.CleanupJob;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.ParsedFileField;
import net.sf.jabref.model.metadata.FileDirectoryPreferences;

public class RenamePdfCleanup
implements CleanupJob {
    private final BibDatabaseContext databaseContext;
    private final boolean onlyRelativePaths;
    private final String fileNamePattern;
    private final LayoutFormatterPreferences prefs;
    private final FileDirectoryPreferences fileDirectoryPreferences;
    private int unsuccessfulRenames;

    public RenamePdfCleanup(boolean onlyRelativePaths, BibDatabaseContext databaseContext, String fileNamePattern, LayoutFormatterPreferences prefs, FileDirectoryPreferences fileDirectoryPreferences) {
        this.databaseContext = Objects.requireNonNull(databaseContext);
        this.onlyRelativePaths = onlyRelativePaths;
        this.fileNamePattern = Objects.requireNonNull(fileNamePattern);
        this.prefs = Objects.requireNonNull(prefs);
        this.fileDirectoryPreferences = fileDirectoryPreferences;
    }

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        TypedBibEntry typedEntry = new TypedBibEntry(entry, this.databaseContext);
        List<ParsedFileField> fileList = typedEntry.getFiles();
        ArrayList<ParsedFileField> newFileList = new ArrayList<ParsedFileField>();
        boolean changed = false;
        for (ParsedFileField flEntry : fileList) {
            String expandedOldFilePath;
            boolean pathsDifferOnlyByCase;
            String realOldFilename = flEntry.getLink();
            if (this.onlyRelativePaths && new File(realOldFilename).isAbsolute()) {
                newFileList.add(flEntry);
                continue;
            }
            StringBuilder newFilename = new StringBuilder(FileUtil.createFileNameFromPattern(this.databaseContext.getDatabase(), entry, this.fileNamePattern, this.prefs).trim());
            newFilename.append('.').append(FileUtil.getFileExtension(realOldFilename).orElse("pdf"));
            Optional<File> expandedOldFile = FileUtil.expandFilename(realOldFilename, this.databaseContext.getFileDirectory(this.fileDirectoryPreferences));
            if (!expandedOldFile.isPresent() || expandedOldFile.get().getParent() == null) {
                newFileList.add(flEntry);
                continue;
            }
            String newPath = expandedOldFile.get().getParent().concat(OS.FILE_SEPARATOR).concat(newFilename.toString());
            boolean bl = pathsDifferOnlyByCase = newPath.equalsIgnoreCase(expandedOldFilePath = expandedOldFile.get().toString()) && !newPath.equals(expandedOldFilePath);
            if (new File(newPath).exists() && !pathsDifferOnlyByCase) {
                newFileList.add(flEntry);
                continue;
            }
            boolean renameSuccessful = FileUtil.renameFile(expandedOldFilePath, newPath);
            if (renameSuccessful) {
                changed = true;
                String description = flEntry.getDescription();
                String type = flEntry.getFileType();
                File parent = new File(realOldFilename).getParentFile();
                String newFileEntryFileName = parent == null || this.databaseContext.getFileDirectory(this.fileDirectoryPreferences).contains(parent.getAbsolutePath()) ? newFilename.toString() : parent.toString().concat(OS.FILE_SEPARATOR).concat(newFilename.toString());
                newFileList.add(new ParsedFileField(description, newFileEntryFileName, type));
                continue;
            }
            ++this.unsuccessfulRenames;
        }
        if (changed) {
            Optional<FieldChange> change = typedEntry.setFiles(newFileList);
            if (change.isPresent()) {
                return Collections.singletonList(change.get());
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public int getUnsuccessfulRenames() {
        return this.unsuccessfulRenames;
    }
}

