/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.cleanup;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.sf.jabref.logic.TypedBibEntry;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.cleanup.CleanupJob;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.ParsedFileField;
import net.sf.jabref.model.metadata.FileDirectoryPreferences;

public class RelativePathsCleanup
implements CleanupJob {
    private final BibDatabaseContext databaseContext;
    private final FileDirectoryPreferences fileDirectoryPreferences;

    public RelativePathsCleanup(BibDatabaseContext databaseContext, FileDirectoryPreferences fileDirectoryPreferences) {
        this.databaseContext = Objects.requireNonNull(databaseContext);
        this.fileDirectoryPreferences = Objects.requireNonNull(fileDirectoryPreferences);
    }

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        TypedBibEntry typedEntry = new TypedBibEntry(entry, this.databaseContext);
        List<ParsedFileField> fileList = typedEntry.getFiles();
        ArrayList<ParsedFileField> newFileList = new ArrayList<ParsedFileField>();
        boolean changed = false;
        for (ParsedFileField fileEntry : fileList) {
            String oldFileName = fileEntry.getLink();
            String newFileName = FileUtil.shortenFileName(new File(oldFileName), this.databaseContext.getFileDirectory(this.fileDirectoryPreferences)).toString();
            ParsedFileField newFileEntry = fileEntry;
            if (!oldFileName.equals(newFileName)) {
                newFileEntry = new ParsedFileField(fileEntry.getDescription(), newFileName, fileEntry.getFileType());
                changed = true;
            }
            newFileList.add(newFileEntry);
        }
        if (changed) {
            Optional<FieldChange> change = typedEntry.setFiles(newFileList);
            if (change.isPresent()) {
                return Collections.singletonList(change.get());
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

