/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.cleanup;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.cleanup.CleanupJob;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.FileField;
import net.sf.jabref.model.entry.ParsedFileField;

public class FileLinksCleanup
implements CleanupJob {
    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        Optional<String> oldValue = entry.getField("file");
        if (!oldValue.isPresent()) {
            return Collections.emptyList();
        }
        List<ParsedFileField> fileList = FileField.parse(oldValue.get());
        String newValue = FileField.getStringRepresentation(fileList);
        if (!oldValue.get().equals(newValue)) {
            entry.setField("file", newValue);
            FieldChange change = new FieldChange(entry, "file", oldValue.get(), newValue);
            return Collections.singletonList(change);
        }
        return Collections.emptyList();
    }
}

