/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.cleanup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.sf.jabref.logic.formatter.bibtexfields.ClearFormatter;
import net.sf.jabref.logic.util.DOI;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.cleanup.CleanupJob;
import net.sf.jabref.model.cleanup.FieldFormatterCleanup;
import net.sf.jabref.model.entry.BibEntry;

public class DoiCleanup
implements CleanupJob {
    private static final List<String> FIELDS = Arrays.asList("note", "url", "ee");

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        ArrayList<FieldChange> changes;
        block4: {
            block3: {
                changes = new ArrayList<FieldChange>();
                if (!entry.hasField("doi")) break block3;
                String doiFieldValue = entry.getField("doi").orElse(null);
                Optional<DOI> doi = DOI.build(doiFieldValue);
                if (!doi.isPresent()) break block4;
                String newValue = doi.get().getDOI();
                if (!doiFieldValue.equals(newValue)) {
                    entry.setField("doi", newValue);
                    FieldChange change = new FieldChange(entry, "doi", doiFieldValue, newValue);
                    changes.add(change);
                }
                for (String field : FIELDS) {
                    entry.getField(field).flatMap(DOI::build).ifPresent(unused -> this.removeFieldValue(entry, field, changes));
                }
                break block4;
            }
            for (String field : FIELDS) {
                Optional doi = entry.getField(field).flatMap(DOI::build);
                if (!doi.isPresent()) continue;
                String oldValue = entry.getField("doi").orElse(null);
                String newValue = ((DOI)doi.get()).getDOI();
                entry.setField("doi", newValue);
                FieldChange change = new FieldChange(entry, "doi", oldValue, newValue);
                changes.add(change);
                this.removeFieldValue(entry, field, changes);
            }
        }
        return changes;
    }

    private void removeFieldValue(BibEntry entry, String field, List<FieldChange> changes) {
        FieldFormatterCleanup eraser = new FieldFormatterCleanup(field, new ClearFormatter());
        changes.addAll(eraser.cleanup(entry));
    }
}

