/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.cleanup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jabref.logic.formatter.Formatters;
import net.sf.jabref.logic.formatter.IdentityFormatter;
import net.sf.jabref.logic.formatter.bibtexfields.HtmlToLatexFormatter;
import net.sf.jabref.logic.formatter.bibtexfields.HtmlToUnicodeFormatter;
import net.sf.jabref.logic.formatter.bibtexfields.NormalizeDateFormatter;
import net.sf.jabref.logic.formatter.bibtexfields.NormalizeMonthFormatter;
import net.sf.jabref.logic.formatter.bibtexfields.NormalizePagesFormatter;
import net.sf.jabref.logic.formatter.bibtexfields.OrdinalsToSuperscriptFormatter;
import net.sf.jabref.logic.formatter.bibtexfields.UnicodeToLatexFormatter;
import net.sf.jabref.logic.layout.format.LatexToUnicodeFormatter;
import net.sf.jabref.model.cleanup.FieldFormatterCleanup;
import net.sf.jabref.model.cleanup.FieldFormatterCleanups;
import net.sf.jabref.model.cleanup.Formatter;
import net.sf.jabref.model.strings.StringUtil;

public class Cleanups {
    public static final FieldFormatterCleanups DEFAULT_SAVE_ACTIONS;
    public static final FieldFormatterCleanups RECOMMEND_BIBTEX_ACTIONS;
    public static final FieldFormatterCleanups RECOMMEND_BIBLATEX_ACTIONS;
    public static List<Formatter> availableFormatters;

    public static List<Formatter> getAvailableFormatters() {
        return Collections.unmodifiableList(availableFormatters);
    }

    public static List<FieldFormatterCleanup> parse(String formatterString) {
        if (formatterString == null || formatterString.isEmpty()) {
            return new ArrayList<FieldFormatterCleanup>();
        }
        ArrayList<FieldFormatterCleanup> actions = new ArrayList<FieldFormatterCleanup>();
        int startIndex = 0;
        String remainingString = formatterString;
        remainingString = StringUtil.unifyLineBreaks(remainingString, "");
        try {
            block2: while (startIndex < formatterString.length()) {
                int currentIndex = remainingString.indexOf(91);
                String fieldKey = remainingString.substring(0, currentIndex);
                int endIndex = remainingString.indexOf(93);
                startIndex += endIndex + 1;
                int tokenIndex = remainingString.indexOf(44);
                while (true) {
                    boolean doBreak = false;
                    if (tokenIndex == -1 || tokenIndex > endIndex) {
                        tokenIndex = remainingString.indexOf(93);
                        doBreak = true;
                    }
                    String formatterKey = remainingString.substring(currentIndex + 1, tokenIndex);
                    actions.add(new FieldFormatterCleanup(fieldKey, Cleanups.getFormatterFromString(formatterKey)));
                    if ((remainingString = remainingString.substring(tokenIndex + 1)).startsWith("]") || doBreak) continue block2;
                    tokenIndex = remainingString.indexOf(44);
                    currentIndex = -1;
                }
            }
        }
        catch (StringIndexOutOfBoundsException ignore) {
            return actions;
        }
        return actions;
    }

    public static FieldFormatterCleanups parse(List<String> formatterMetaList) {
        if (formatterMetaList != null && formatterMetaList.size() >= 2) {
            boolean enablementStatus = "enabled".equals(formatterMetaList.get(0));
            String formatterString = formatterMetaList.get(1);
            return new FieldFormatterCleanups(enablementStatus, Cleanups.parse(formatterString));
        }
        return DEFAULT_SAVE_ACTIONS;
    }

    private static Formatter getFormatterFromString(String formatterName) {
        for (Formatter formatter : availableFormatters) {
            if (!formatterName.equals(formatter.getKey())) continue;
            return formatter;
        }
        return new IdentityFormatter();
    }

    static {
        availableFormatters = new ArrayList<Formatter>();
        availableFormatters.addAll(Formatters.ALL);
        ArrayList<FieldFormatterCleanup> defaultFormatters = new ArrayList<FieldFormatterCleanup>();
        defaultFormatters.add(new FieldFormatterCleanup("pages", new NormalizePagesFormatter()));
        defaultFormatters.add(new FieldFormatterCleanup("date", new NormalizeDateFormatter()));
        defaultFormatters.add(new FieldFormatterCleanup("month", new NormalizeMonthFormatter()));
        DEFAULT_SAVE_ACTIONS = new FieldFormatterCleanups(false, defaultFormatters);
        ArrayList<FieldFormatterCleanup> recommendedBibTeXFormatters = new ArrayList<FieldFormatterCleanup>();
        recommendedBibTeXFormatters.addAll(defaultFormatters);
        recommendedBibTeXFormatters.add(new FieldFormatterCleanup("title", new HtmlToLatexFormatter()));
        recommendedBibTeXFormatters.add(new FieldFormatterCleanup("title", new UnicodeToLatexFormatter()));
        recommendedBibTeXFormatters.add(new FieldFormatterCleanup("booktitle", new UnicodeToLatexFormatter()));
        recommendedBibTeXFormatters.add(new FieldFormatterCleanup("journal", new UnicodeToLatexFormatter()));
        recommendedBibTeXFormatters.add(new FieldFormatterCleanup("author", new UnicodeToLatexFormatter()));
        recommendedBibTeXFormatters.add(new FieldFormatterCleanup("editor", new UnicodeToLatexFormatter()));
        recommendedBibTeXFormatters.add(new FieldFormatterCleanup("all-text-fields", new OrdinalsToSuperscriptFormatter()));
        RECOMMEND_BIBTEX_ACTIONS = new FieldFormatterCleanups(false, recommendedBibTeXFormatters);
        ArrayList<FieldFormatterCleanup> recommendedBibLaTeXFormatters = new ArrayList<FieldFormatterCleanup>();
        recommendedBibLaTeXFormatters.addAll(defaultFormatters);
        recommendedBibLaTeXFormatters.add(new FieldFormatterCleanup("title", new HtmlToUnicodeFormatter()));
        recommendedBibLaTeXFormatters.add(new FieldFormatterCleanup("all-text-fields", new LatexToUnicodeFormatter()));
        recommendedBibLaTeXFormatters.add(new FieldFormatterCleanup("all-text-fields", new OrdinalsToSuperscriptFormatter()));
        RECOMMEND_BIBLATEX_ACTIONS = new FieldFormatterCleanups(false, recommendedBibLaTeXFormatters);
    }
}

