/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.cleanup;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import net.sf.jabref.logic.cleanup.Cleanups;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.model.cleanup.FieldFormatterCleanup;
import net.sf.jabref.model.cleanup.FieldFormatterCleanups;
import net.sf.jabref.preferences.JabRefPreferences;

public class CleanupPreset {
    private final Set<CleanupStep> activeJobs;
    private final FieldFormatterCleanups formatterCleanups;

    public CleanupPreset(Set<CleanupStep> activeJobs) {
        this(activeJobs, new FieldFormatterCleanups(false, new ArrayList<FieldFormatterCleanup>()));
    }

    public CleanupPreset(CleanupStep activeJob) {
        this(EnumSet.of(activeJob));
    }

    public CleanupPreset(FieldFormatterCleanups formatterCleanups) {
        this(EnumSet.noneOf(CleanupStep.class), formatterCleanups);
    }

    public CleanupPreset(Set<CleanupStep> activeJobs, FieldFormatterCleanups formatterCleanups) {
        this.activeJobs = activeJobs;
        this.formatterCleanups = Objects.requireNonNull(formatterCleanups);
    }

    public static CleanupPreset loadFromPreferences(JabRefPreferences preferences) {
        EnumSet<CleanupStep> activeJobs = EnumSet.noneOf(CleanupStep.class);
        if (preferences.getBoolean("CleanUpDOI")) {
            activeJobs.add(CleanupStep.CLEAN_UP_DOI);
        }
        if (preferences.getBoolean("CleanUpISSN")) {
            activeJobs.add(CleanupStep.CLEAN_UP_ISSN);
        }
        if (preferences.getBoolean("CleanUpMovePDF")) {
            activeJobs.add(CleanupStep.MOVE_PDF);
        }
        if (preferences.getBoolean("CleanUpMakePathsRelative")) {
            activeJobs.add(CleanupStep.MAKE_PATHS_RELATIVE);
        }
        if (preferences.getBoolean("CleanUpRenamePDF")) {
            activeJobs.add(CleanupStep.RENAME_PDF);
        }
        if (preferences.getBoolean("CleanUpRenamePDFonlyRelativePaths")) {
            activeJobs.add(CleanupStep.RENAME_PDF_ONLY_RELATIVE_PATHS);
        }
        if (preferences.getBoolean("CleanUpUpgradeExternalLinks")) {
            activeJobs.add(CleanupStep.CLEAN_UP_UPGRADE_EXTERNAL_LINKS);
        }
        if (preferences.getBoolean("CleanUpConvertToBiblatex")) {
            activeJobs.add(CleanupStep.CONVERT_TO_BIBLATEX);
        }
        if (preferences.getBoolean("CleanUpFixFileLinks")) {
            activeJobs.add(CleanupStep.FIX_FILE_LINKS);
        }
        FieldFormatterCleanups formatterCleanups = Cleanups.parse(preferences.getStringList("CleanUpFormatters"));
        return new CleanupPreset(activeJobs, formatterCleanups);
    }

    public boolean isCleanUpUpgradeExternalLinks() {
        return this.isActive(CleanupStep.CLEAN_UP_UPGRADE_EXTERNAL_LINKS);
    }

    public boolean isCleanUpDOI() {
        return this.isActive(CleanupStep.CLEAN_UP_DOI);
    }

    public boolean isCleanUpISSN() {
        return this.isActive(CleanupStep.CLEAN_UP_ISSN);
    }

    public boolean isFixFileLinks() {
        return this.isActive(CleanupStep.FIX_FILE_LINKS);
    }

    public boolean isMovePDF() {
        return this.isActive(CleanupStep.MOVE_PDF);
    }

    public boolean isMakePathsRelative() {
        return this.isActive(CleanupStep.MAKE_PATHS_RELATIVE);
    }

    public boolean isRenamePDF() {
        return this.isActive(CleanupStep.RENAME_PDF) != false || this.isActive(CleanupStep.RENAME_PDF_ONLY_RELATIVE_PATHS) != false;
    }

    public boolean isConvertToBiblatex() {
        return this.isActive(CleanupStep.CONVERT_TO_BIBLATEX);
    }

    public boolean isRenamePdfOnlyRelativePaths() {
        return this.isActive(CleanupStep.RENAME_PDF_ONLY_RELATIVE_PATHS);
    }

    public void storeInPreferences(JabRefPreferences preferences) {
        preferences.putBoolean("CleanUpDOI", this.isActive(CleanupStep.CLEAN_UP_DOI));
        preferences.putBoolean("CleanUpISSN", this.isActive(CleanupStep.CLEAN_UP_ISSN));
        preferences.putBoolean("CleanUpMovePDF", this.isActive(CleanupStep.MOVE_PDF));
        preferences.putBoolean("CleanUpMakePathsRelative", this.isActive(CleanupStep.MAKE_PATHS_RELATIVE));
        preferences.putBoolean("CleanUpRenamePDF", this.isActive(CleanupStep.RENAME_PDF));
        preferences.putBoolean("CleanUpRenamePDFonlyRelativePaths", this.isActive(CleanupStep.RENAME_PDF_ONLY_RELATIVE_PATHS));
        preferences.putBoolean("CleanUpUpgradeExternalLinks", this.isActive(CleanupStep.CLEAN_UP_UPGRADE_EXTERNAL_LINKS));
        preferences.putBoolean("CleanUpConvertToBiblatex", this.isActive(CleanupStep.CONVERT_TO_BIBLATEX));
        preferences.putBoolean("CleanUpFixFileLinks", this.isActive(CleanupStep.FIX_FILE_LINKS));
        preferences.putStringList("CleanUpFormatters", this.formatterCleanups.getAsStringList(OS.NEWLINE));
    }

    private Boolean isActive(CleanupStep step) {
        return this.activeJobs.contains((Object)step);
    }

    public FieldFormatterCleanups getFormatterCleanups() {
        return this.formatterCleanups;
    }

    public static enum CleanupStep {
        CLEAN_UP_DOI,
        MAKE_PATHS_RELATIVE,
        RENAME_PDF,
        RENAME_PDF_ONLY_RELATIVE_PATHS,
        CLEAN_UP_UPGRADE_EXTERNAL_LINKS,
        CONVERT_TO_BIBLATEX,
        MOVE_PDF,
        FIX_FILE_LINKS,
        CLEAN_UP_ISSN;

    }
}

