/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.cleanup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.cleanup.CleanupJob;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.EntryConverter;

public class BiblatexCleanup
implements CleanupJob {
    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        for (Map.Entry<String, String> alias : EntryConverter.FIELD_ALIASES_TEX_TO_LTX.entrySet()) {
            String oldFieldName = alias.getKey();
            String newFieldName = alias.getValue();
            entry.getField(oldFieldName).ifPresent(oldValue -> {
                if (!oldValue.isEmpty() && !entry.getField(newFieldName).isPresent()) {
                    entry.setField(newFieldName, (String)oldValue);
                    changes.add(new FieldChange(entry, newFieldName, null, (String)oldValue));
                    entry.clearField(oldFieldName);
                    changes.add(new FieldChange(entry, oldFieldName, (String)oldValue, null));
                }
            });
        }
        entry.getField("date").ifPresent(date -> {
            if (date.isEmpty()) {
                entry.getFieldOrAlias("date").ifPresent(newDate -> {
                    Optional<String> oldYear = entry.getField("year");
                    Optional<String> oldMonth = entry.getField("month");
                    entry.setField("date", (String)newDate);
                    entry.clearField("year");
                    entry.clearField("month");
                    changes.add(new FieldChange(entry, "date", null, (String)newDate));
                    changes.add(new FieldChange(entry, "year", oldYear.orElse(null), null));
                    changes.add(new FieldChange(entry, "month", oldMonth.orElse(null), null));
                });
            }
        });
        return changes;
    }
}

