/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.citationstyle;

import de.undercouch.citeproc.CSL;
import de.undercouch.citeproc.bibtex.BibTeXConverter;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.output.Bibliography;
import java.io.IOException;
import java.util.Map;
import net.sf.jabref.logic.citationstyle.CitationStyle;
import net.sf.jabref.logic.citationstyle.CitationStyleOutputFormat;
import net.sf.jabref.logic.formatter.bibtexfields.UnicodeToLatexFormatter;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbibtex.BibTeXEntry;
import org.jbibtex.DigitStringValue;
import org.jbibtex.Key;
import org.jbibtex.TokenMgrException;

public class CitationStyleGenerator {
    private static final Log LOGGER = LogFactory.getLog(CitationStyleGenerator.class);
    private static final UnicodeToLatexFormatter UNICODE_TO_LATEX_FORMATTER = new UnicodeToLatexFormatter();
    private static final BibTeXConverter BIBTEX_CONVERTER = new BibTeXConverter();

    protected static String generateCitation(BibEntry entry, CitationStyle style) {
        return CitationStyleGenerator.generateCitation(entry, style.getSource(), CitationStyleOutputFormat.HTML);
    }

    protected static String generateCitation(BibEntry entry, String style) {
        return CitationStyleGenerator.generateCitation(entry, style, CitationStyleOutputFormat.HTML);
    }

    protected static String generateCitation(BibEntry entry, String style, CitationStyleOutputFormat outputFormat) {
        try {
            String citeKey = entry.getCiteKeyOptional().orElse("");
            BibTeXEntry bibTeXEntry = new BibTeXEntry(new Key(entry.getType()), new Key(citeKey));
            for (Map.Entry<String, String> field : entry.getFieldMap().entrySet()) {
                String value = UNICODE_TO_LATEX_FORMATTER.format(field.getValue());
                bibTeXEntry.addField(new Key(field.getKey()), new DigitStringValue(value));
            }
            CSLItemData cslItemData = BIBTEX_CONVERTER.toItemData(bibTeXEntry);
            Bibliography bibliography = CSL.makeAdhocBibliography(style, outputFormat.getFormat(), cslItemData);
            return bibliography.getEntries()[0];
        }
        catch (IOException | ArrayIndexOutOfBoundsException e) {
            LOGGER.error("Could not generate BibEntry citation", e);
            return Localization.lang("Cannot generate preview based on selected citation style.", new String[0]);
        }
        catch (TokenMgrException e) {
            LOGGER.error("Bad character inside BibEntry", e);
            return Localization.lang("Cannot generate preview based on selected citation style.", new String[0]) + (outputFormat == CitationStyleOutputFormat.HTML ? "<br>" : "\n") + Localization.lang("Bad character inside entry", new String[0]) + (outputFormat == CitationStyleOutputFormat.HTML ? "<br>" : "\n") + e.getLocalizedMessage();
        }
    }
}

