/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.citationstyle;

import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.sf.jabref.logic.citationstyle.CitationStyle;
import net.sf.jabref.logic.citationstyle.CitationStyleGenerator;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.database.event.EntryRemovedEvent;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.event.EntryChangedEvent;

public class CitationStyleCache {
    private CitationStyle citationStyle = CitationStyle.getDefault();
    private Map<BibEntry, String> citationStylesCache = new HashMap<BibEntry, String>();

    public CitationStyleCache(BibDatabaseContext bibDatabaseContext) {
        this(bibDatabaseContext, CitationStyle.getDefault());
    }

    public CitationStyleCache(BibDatabaseContext bibDatabaseContext, CitationStyle citationStyle) {
        this.setCitationStyle(citationStyle);
        bibDatabaseContext.getDatabase().registerListener(new BibDatabaseEntryListener());
    }

    public String getCitationFor(BibEntry entry) {
        String citation = this.citationStylesCache.get(entry);
        if (citation == null) {
            citation = CitationStyleGenerator.generateCitation(entry, this.citationStyle);
            this.citationStylesCache.put(entry, citation);
        }
        return citation;
    }

    public void setCitationStyle(CitationStyle citationStyle) {
        Objects.requireNonNull(citationStyle);
        if (!this.citationStyle.equals(citationStyle)) {
            this.citationStyle = citationStyle;
            this.citationStylesCache.clear();
        }
    }

    public CitationStyle getCitationStyle() {
        return this.citationStyle;
    }

    private class BibDatabaseEntryListener {
        private BibDatabaseEntryListener() {
        }

        @Subscribe
        public void listen(EntryChangedEvent entryChangedEvent) {
            CitationStyleCache.this.citationStylesCache.remove(entryChangedEvent.getBibEntry());
        }

        @Subscribe
        public void listen(EntryRemovedEvent entryRemovedEvent) {
            CitationStyleCache.this.citationStylesCache.remove(entryRemovedEvent.getBibEntry());
        }
    }
}

