/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.citationstyle;

import de.undercouch.citeproc.helper.CSLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jabref.logic.util.FileExtensions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CitationStyle {
    public static final String DEFAULT = "/ieee.csl";
    private static final Log LOGGER = LogFactory.getLog(CitationStyle.class);
    private final String filepath;
    private final String title;
    private final String source;

    private CitationStyle(String filename, String title, String source) {
        this.filepath = Objects.requireNonNull(filename);
        this.title = Objects.requireNonNull(title);
        this.source = Objects.requireNonNull(source);
    }

    private static CitationStyle createCitationStyleFromSource(String source, String filename) {
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(source));
            Document doc = db.parse(is);
            NodeList nodes = doc.getElementsByTagName("info");
            NodeList titleNode = ((Element)nodes.item(0)).getElementsByTagName("title");
            String title = ((CharacterData)titleNode.item(0).getFirstChild()).getData();
            return new CitationStyle(filename, title, source);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.error("Error while parsing source", e);
            return null;
        }
    }

    public static CitationStyle createCitationStyleFromFile(String styleFile) {
        if (!CitationStyle.isCitationStyleFile(styleFile)) {
            LOGGER.error("Can only load style files: " + styleFile);
            return null;
        }
        try {
            String internalFile = (styleFile.startsWith("/") ? "" : "/") + styleFile;
            URL url = CitationStyle.class.getResource(internalFile);
            String text = url != null ? CSLUtils.readURLToString(url, StandardCharsets.UTF_8.toString()) : new String(Files.readAllBytes(Paths.get(styleFile, new String[0])), StandardCharsets.UTF_8);
            return CitationStyle.createCitationStyleFromSource(text, styleFile);
        }
        catch (NoSuchFileException e) {
            LOGGER.error("Could not find file: " + styleFile, e);
        }
        catch (IOException e) {
            LOGGER.error("Error reading source file", e);
        }
        return null;
    }

    public static CitationStyle getDefault() {
        return CitationStyle.createCitationStyleFromFile(DEFAULT);
    }

    public static List<CitationStyle> discoverCitationStyles() {
        try {
            ArrayList<CitationStyle> citationStyles = new ArrayList<CitationStyle>();
            String path = CitationStyle.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            try (JarFile file = new JarFile(path);){
                Enumeration<JarEntry> entries = file.entries();
                while (entries.hasMoreElements()) {
                    CitationStyle citationStyle;
                    String filename = entries.nextElement().getName();
                    if (filename.startsWith("dependent") || !filename.endsWith("csl") || (citationStyle = CitationStyle.createCitationStyleFromFile(filename)) == null) continue;
                    citationStyles.add(citationStyle);
                }
            }
            return citationStyles;
        }
        catch (IOException | URISyntaxException ex) {
            LOGGER.error("something went wrong while searching available CitationStyles. Are you running directly from source code?", ex);
            return Collections.emptyList();
        }
    }

    public static boolean isCitationStyleFile(String styleFile) {
        return Arrays.stream(FileExtensions.CITATION_STYLE.getExtensions()).anyMatch(styleFile::endsWith);
    }

    public String getTitle() {
        return this.title;
    }

    public String getSource() {
        return this.source;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public String toString() {
        return this.title;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CitationStyle that = (CitationStyle)other;
        return this.source != null ? this.source.equals(that.source) : that.source == null;
    }
}

