/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.bst;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.logic.bst.BstLexer;
import net.sf.jabref.logic.bst.BstParser;
import net.sf.jabref.logic.bst.ChangeCaseFunction;
import net.sf.jabref.logic.bst.FormatNameFunction;
import net.sf.jabref.logic.bst.PurifyFunction;
import net.sf.jabref.logic.bst.TextPrefixFunction;
import net.sf.jabref.logic.bst.VMException;
import net.sf.jabref.logic.bst.Warn;
import net.sf.jabref.logic.bst.WidthFunction;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.AuthorList;
import net.sf.jabref.model.entry.BibEntry;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VM
implements Warn {
    private static final Log LOGGER = LogFactory.getLog(VM.class);
    private List<BstEntry> entries;
    private Map<String, String> strings = new HashMap<String, String>();
    private Map<String, Integer> integers = new HashMap<String, Integer>();
    private Map<String, BstFunction> functions = new HashMap<String, BstFunction>();
    private Stack<Object> stack = new Stack();
    public static final Integer FALSE = 0;
    public static final Integer TRUE = 1;
    private final Map<String, BstFunction> buildInFunctions;
    private File file;
    private final CommonTree tree;
    private StringBuilder bbl;
    private String preamble = "";
    private static final Pattern ADD_PERIOD_PATTERN = Pattern.compile("([^\\.\\?\\!\\}\\s])(\\}|\\s)*$");

    public VM(File f) throws RecognitionException, IOException {
        this(new ANTLRFileStream(f.getPath()));
        this.file = f;
    }

    public VM(String s) throws RecognitionException {
        this(new ANTLRStringStream(s));
    }

    private VM(CharStream bst) throws RecognitionException {
        this(VM.charStream2CommonTree(bst));
    }

    private VM(CommonTree tree) {
        this.tree = tree;
        this.buildInFunctions = new HashMap<String, BstFunction>(37);
        this.buildInFunctions.put(">", context -> {
            if (this.stack.size() < 2) {
                throw new VMException("Not enough operands on stack for operation >");
            }
            Object o2 = this.stack.pop();
            Object o1 = this.stack.pop();
            if (!(o1 instanceof Integer) || !(o2 instanceof Integer)) {
                throw new VMException("Can only compare two integers with >");
            }
            this.stack.push(((Integer)o1).compareTo((Integer)o2) > 0 ? TRUE : FALSE);
        });
        this.buildInFunctions.put("<", context -> {
            if (this.stack.size() < 2) {
                throw new VMException("Not enough operands on stack for operation <");
            }
            Object o2 = this.stack.pop();
            Object o1 = this.stack.pop();
            if (!(o1 instanceof Integer) || !(o2 instanceof Integer)) {
                throw new VMException("Can only compare two integers with <");
            }
            this.stack.push(((Integer)o1).compareTo((Integer)o2) < 0 ? TRUE : FALSE);
        });
        this.buildInFunctions.put("=", context -> {
            Object o2;
            if (this.stack.size() < 2) {
                throw new VMException("Not enough operands on stack for operation =");
            }
            Object o1 = this.stack.pop();
            if (o1 == null ^ (o2 = this.stack.pop()) == null) {
                this.stack.push(FALSE);
                return;
            }
            if (o1 == null && o2 == null) {
                this.stack.push(TRUE);
                return;
            }
            this.stack.push(o1.equals(o2) ? TRUE : FALSE);
        });
        this.buildInFunctions.put("+", context -> {
            if (this.stack.size() < 2) {
                throw new VMException("Not enough operands on stack for operation +");
            }
            Object o2 = this.stack.pop();
            Object o1 = this.stack.pop();
            if (!(o1 instanceof Integer) || !(o2 instanceof Integer)) {
                throw new VMException("Can only compare two integers with +");
            }
            this.stack.push((Integer)o1 + (Integer)o2);
        });
        this.buildInFunctions.put("-", context -> {
            if (this.stack.size() < 2) {
                throw new VMException("Not enough operands on stack for operation -");
            }
            Object o2 = this.stack.pop();
            Object o1 = this.stack.pop();
            if (!(o1 instanceof Integer) || !(o2 instanceof Integer)) {
                throw new VMException("Can only subtract two integers with -");
            }
            this.stack.push((Integer)o1 - (Integer)o2);
        });
        this.buildInFunctions.put("*", context -> {
            if (this.stack.size() < 2) {
                throw new VMException("Not enough operands on stack for operation *");
            }
            Object o2 = this.stack.pop();
            Object o1 = this.stack.pop();
            if (!(o1 instanceof String) || !(o2 instanceof String)) {
                throw new VMException("Can only concatenate two String with *");
            }
            this.stack.push(o1.toString() + o2);
        });
        this.buildInFunctions.put(":=", context -> {
            if (this.stack.size() < 2) {
                throw new VMException("Invalid call to operation :=");
            }
            Object o1 = this.stack.pop();
            Object o2 = this.stack.pop();
            this.assign(context, o1, o2);
        });
        this.buildInFunctions.put("add.period$", context -> this.addPeriodFunction());
        this.buildInFunctions.put("call.type$", context -> {
            if (context == null) {
                throw new VMException("Call.type$ can only be called from within a context (ITERATE or REVERSE).");
            }
            this.execute(context.getBibtexEntry().getType(), context);
        });
        this.buildInFunctions.put("change.case$", new ChangeCaseFunction(this));
        this.buildInFunctions.put("chr.to.int$", context -> {
            if (this.stack.isEmpty()) {
                throw new VMException("Not enough operands on stack for operation chr.to.int$");
            }
            Object o1 = this.stack.pop();
            if (!(o1 instanceof String) || ((String)o1).length() != 1) {
                throw new VMException("Can only perform chr.to.int$ on string with length 1");
            }
            String s = (String)o1;
            this.stack.push(s.charAt(0));
        });
        this.buildInFunctions.put("cite$", context -> {
            if (context == null) {
                throw new VMException("Must have an entry to cite$");
            }
            this.stack.push(context.getBibtexEntry().getCiteKeyOptional().orElse(null));
        });
        this.buildInFunctions.put("duplicate$", context -> {
            if (this.stack.isEmpty()) {
                throw new VMException("Not enough operands on stack for operation duplicate$");
            }
            Object o1 = this.stack.pop();
            this.stack.push(o1);
            this.stack.push(o1);
        });
        this.buildInFunctions.put("empty$", context -> {
            if (this.stack.isEmpty()) {
                throw new VMException("Not enough operands on stack for operation empty$");
            }
            Object o1 = this.stack.pop();
            if (o1 == null) {
                this.stack.push(TRUE);
                return;
            }
            if (!(o1 instanceof String)) {
                throw new VMException("Operand does not match function empty$");
            }
            String s = (String)o1;
            this.stack.push("".equals(s.trim()) ? TRUE : FALSE);
        });
        this.buildInFunctions.put("format.name$", new FormatNameFunction(this));
        this.buildInFunctions.put("if$", context -> {
            if (this.stack.size() < 3) {
                throw new VMException("Not enough operands on stack for operation =");
            }
            Object f1 = this.stack.pop();
            Object f2 = this.stack.pop();
            Object i = this.stack.pop();
            if (!(f1 instanceof Identifier) && !(f1 instanceof Tree) && (f2 instanceof Identifier || f2 instanceof Tree) && i instanceof Integer) {
                throw new VMException("Expecting two functions and an integer for if$.");
            }
            if ((Integer)i > 0) {
                this.executeInContext(f2, context);
            } else {
                this.executeInContext(f1, context);
            }
        });
        this.buildInFunctions.put("int.to.chr$", context -> {
            if (this.stack.isEmpty()) {
                throw new VMException("Not enough operands on stack for operation int.to.chr$");
            }
            Object o1 = this.stack.pop();
            if (!(o1 instanceof Integer)) {
                throw new VMException("Can only perform operation int.to.chr$ on an Integer");
            }
            Integer i = (Integer)o1;
            this.stack.push(String.valueOf((char)i.intValue()));
        });
        this.buildInFunctions.put("int.to.str$", context -> {
            if (this.stack.isEmpty()) {
                throw new VMException("Not enough operands on stack for operation int.to.str$");
            }
            Object o1 = this.stack.pop();
            if (!(o1 instanceof Integer)) {
                throw new VMException("Can only transform an integer to an string using int.to.str$");
            }
            this.stack.push(o1.toString());
        });
        this.buildInFunctions.put("missing$", context -> {
            if (this.stack.isEmpty()) {
                throw new VMException("Not enough operands on stack for operation missing$");
            }
            Object o1 = this.stack.pop();
            if (o1 == null) {
                this.stack.push(TRUE);
                return;
            }
            if (!(o1 instanceof String)) {
                this.warn("Not a string or missing field in operation missing$");
                this.stack.push(TRUE);
                return;
            }
            this.stack.push(FALSE);
        });
        this.buildInFunctions.put("newline$", context -> this.bbl.append('\n'));
        this.buildInFunctions.put("num.names$", context -> {
            if (this.stack.isEmpty()) {
                throw new VMException("Not enough operands on stack for operation num.names$");
            }
            Object o1 = this.stack.pop();
            if (!(o1 instanceof String)) {
                throw new VMException("Need a string at the top of the stack for num.names$");
            }
            String s = (String)o1;
            this.stack.push(AuthorList.parse(s).getNumberOfAuthors());
        });
        this.buildInFunctions.put("pop$", context -> this.stack.pop());
        this.buildInFunctions.put("preamble$", context -> this.stack.push(this.preamble));
        this.buildInFunctions.put("purify$", new PurifyFunction(this));
        this.buildInFunctions.put("quote$", context -> this.stack.push("\""));
        this.buildInFunctions.put("skip$", context -> {});
        this.buildInFunctions.put("stack$", context -> {
            while (!this.stack.empty()) {
                LOGGER.debug(this.stack.pop());
            }
        });
        this.buildInFunctions.put("substring$", context -> this.substringFunction());
        this.buildInFunctions.put("swap$", context -> {
            if (this.stack.size() < 2) {
                throw new VMException("Not enough operands on stack for operation swap$");
            }
            Object f1 = this.stack.pop();
            Object f2 = this.stack.pop();
            this.stack.push(f1);
            this.stack.push(f2);
        });
        this.buildInFunctions.put("text.length$", context -> this.textLengthFunction());
        this.buildInFunctions.put("text.prefix$", new TextPrefixFunction(this));
        this.buildInFunctions.put("top$", context -> LOGGER.debug(this.stack.pop()));
        this.buildInFunctions.put("type$", context -> {
            if (context == null) {
                throw new VMException("type$ need a context.");
            }
            this.stack.push(context.getBibtexEntry().getType());
        });
        this.buildInFunctions.put("warning$", new BstFunction(){
            int warning = 1;

            @Override
            public void execute(BstEntry context) {
                LOGGER.warn("Warning (#" + this.warning++ + "): " + VM.this.stack.pop());
            }
        });
        this.buildInFunctions.put("while$", this::whileFunction);
        this.buildInFunctions.put("width$", new WidthFunction(this));
        this.buildInFunctions.put("write$", context -> {
            String s = (String)this.stack.pop();
            this.bbl.append(s);
        });
    }

    private void textLengthFunction() {
        if (this.stack.isEmpty()) {
            throw new VMException("Not enough operands on stack for operation text.length$");
        }
        Object o1 = this.stack.pop();
        if (!(o1 instanceof String)) {
            throw new VMException("Can only perform operation on a string text.length$");
        }
        String s = (String)o1;
        char[] c = s.toCharArray();
        int result = 0;
        int i = 0;
        int n = s.length();
        int braceLevel = 0;
        while (i < n) {
            if (c[++i - 1] == '{') {
                if (++braceLevel != 1 || i >= n || c[i] != '\\') continue;
                ++i;
                while (i < n && braceLevel > 0) {
                    if (c[i] == '}') {
                        --braceLevel;
                    } else if (c[i] == '{') {
                        ++braceLevel;
                    }
                    ++i;
                }
                ++result;
                continue;
            }
            if (c[i - 1] == '}') {
                if (braceLevel <= 0) continue;
                --braceLevel;
                continue;
            }
            ++result;
        }
        this.stack.push(result);
    }

    private void whileFunction(BstEntry context) {
        if (this.stack.size() < 2) {
            throw new VMException("Not enough operands on stack for operation while$");
        }
        Object f2 = this.stack.pop();
        Object f1 = this.stack.pop();
        if (!(f1 instanceof Identifier) && !(f1 instanceof Tree) && (f2 instanceof Identifier || f2 instanceof Tree)) {
            throw new VMException("Expecting two functions for while$.");
        }
        while (true) {
            this.executeInContext(f1, context);
            Object i = this.stack.pop();
            if (!(i instanceof Integer)) {
                throw new VMException("First parameter to while has to return an integer but was " + i);
            }
            if ((Integer)i <= 0) break;
            this.executeInContext(f2, context);
        }
    }

    private void substringFunction() {
        if (this.stack.size() < 3) {
            throw new VMException("Not enough operands on stack for operation substring$");
        }
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        Object o3 = this.stack.pop();
        if (!(o1 instanceof Integer && o2 instanceof Integer && o3 instanceof String)) {
            throw new VMException("Expecting two integers and a string for substring$");
        }
        Integer len = (Integer)o1;
        Integer start = (Integer)o2;
        int lenI = len;
        int startI = start;
        if (lenI > 0x3FFFFFFF) {
            lenI = 0x3FFFFFFF;
        }
        if (startI > 0x3FFFFFFF) {
            startI = 0x3FFFFFFF;
        }
        if (startI < -1073741824) {
            startI = -1073741824;
        }
        String s = (String)o3;
        if (startI < 0) {
            startI += s.length() + 1;
            startI = Math.max(1, startI + 1 - lenI);
        }
        this.stack.push(s.substring(startI - 1, Math.min(startI - 1 + lenI, s.length())));
    }

    private void addPeriodFunction() {
        if (this.stack.isEmpty()) {
            throw new VMException("Not enough operands on stack for operation add.period$");
        }
        Object o1 = this.stack.pop();
        if (!(o1 instanceof String)) {
            throw new VMException("Can only add a period to a string for add.period$");
        }
        String s = (String)o1;
        Matcher m = ADD_PERIOD_PATTERN.matcher(s);
        if (m.find()) {
            StringBuffer sb = new StringBuffer();
            m.appendReplacement(sb, m.group(1));
            sb.append('.');
            String group2 = m.group(2);
            if (group2 != null) {
                sb.append(m.group(2));
            }
            this.stack.push(sb.toString());
        } else {
            this.stack.push(s);
        }
    }

    private static CommonTree charStream2CommonTree(CharStream bst) throws RecognitionException {
        BstLexer lex = new BstLexer(bst);
        CommonTokenStream tokens = new CommonTokenStream(lex);
        BstParser parser = new BstParser(tokens);
        BstParser.program_return r = parser.program();
        return (CommonTree)r.getTree();
    }

    private boolean assign(BstEntry context, Object o1, Object o2) {
        if (!(o1 instanceof Identifier) || !(o2 instanceof String) && !(o2 instanceof Integer)) {
            throw new VMException("Invalid parameters");
        }
        String name = ((Identifier)o1).getName();
        if (o2 instanceof String) {
            if (context != null && context.localStrings.containsKey(name)) {
                context.localStrings.put(name, (String)o2);
                return true;
            }
            if (this.strings.containsKey(name)) {
                this.strings.put(name, (String)o2);
                return true;
            }
            return false;
        }
        if (context != null && context.localIntegers.containsKey(name)) {
            context.localIntegers.put(name, (Integer)o2);
            return true;
        }
        if (this.integers.containsKey(name)) {
            this.integers.put(name, (Integer)o2);
            return true;
        }
        return false;
    }

    public String run(BibDatabase db) {
        this.preamble = db.getPreamble().orElse("");
        return this.run(db.getEntries());
    }

    public String run(Collection<BibEntry> bibtex) {
        this.bbl = new StringBuilder();
        this.strings = new HashMap<String, String>();
        this.integers = new HashMap<String, Integer>();
        this.integers.put("entry.max$", Integer.MAX_VALUE);
        this.integers.put("global.max$", Integer.MAX_VALUE);
        this.functions = new HashMap<String, BstFunction>();
        this.functions.putAll(this.buildInFunctions);
        this.stack = new Stack();
        this.entries = new ArrayList<BstEntry>(bibtex.size());
        ListIterator<BstEntry> listIter = this.entries.listIterator();
        for (BibEntry entry : bibtex) {
            listIter.add(new BstEntry(entry));
        }
        block13: for (int i = 0; i < this.tree.getChildCount(); ++i) {
            Tree child = this.tree.getChild(i);
            switch (child.getType()) {
                case 23: {
                    this.strings(child);
                    continue block13;
                }
                case 11: {
                    this.integers(child);
                    continue block13;
                }
                case 7: {
                    this.function(child);
                    continue block13;
                }
                case 6: {
                    this.execute(child);
                    continue block13;
                }
                case 20: {
                    this.sort();
                    continue block13;
                }
                case 12: {
                    this.iterate(child);
                    continue block13;
                }
                case 19: {
                    this.reverse(child);
                    continue block13;
                }
                case 5: {
                    this.entry(child);
                    continue block13;
                }
                case 18: {
                    this.read();
                    continue block13;
                }
                case 15: {
                    this.macro(child);
                    continue block13;
                }
                default: {
                    LOGGER.info("Unknown type: " + child.getType());
                }
            }
        }
        return this.bbl.toString();
    }

    private void read() {
        for (BstEntry e : this.entries) {
            for (Map.Entry<String, String> mEntry : e.getFields().entrySet()) {
                String fieldValue = e.getBibtexEntry().getField(mEntry.getKey()).orElse(null);
                mEntry.setValue(fieldValue);
            }
        }
        for (BstEntry e : this.entries) {
            if (e.getFields().containsKey("crossref")) continue;
            e.getFields().put("crossref", null);
        }
    }

    private void macro(Tree child) {
        String name = child.getChild(0).getText();
        String replacement = child.getChild(1).getText();
        this.functions.put(name, new MacroFunction(replacement));
    }

    private void entry(Tree child) {
        String name;
        int i;
        Tree t = child.getChild(0);
        for (i = 0; i < t.getChildCount(); ++i) {
            name = t.getChild(i).getText();
            for (BstEntry entry : this.entries) {
                entry.getFields().put(name, null);
            }
        }
        t = child.getChild(1);
        for (i = 0; i < t.getChildCount(); ++i) {
            name = t.getChild(i).getText();
            for (BstEntry entry : this.entries) {
                entry.localIntegers.put(name, 0);
            }
        }
        t = child.getChild(2);
        for (i = 0; i < t.getChildCount(); ++i) {
            name = t.getChild(i).getText();
            for (BstEntry entry : this.entries) {
                entry.localStrings.put(name, null);
            }
        }
        for (BstEntry entry : this.entries) {
            entry.localStrings.put("sort.key$", null);
        }
    }

    private void reverse(Tree child) {
        BstFunction f = this.functions.get(child.getChild(0).getText());
        ListIterator<BstEntry> i = this.entries.listIterator(this.entries.size());
        while (i.hasPrevious()) {
            f.execute(i.previous());
        }
    }

    private void iterate(Tree child) {
        BstFunction f = this.functions.get(child.getChild(0).getText());
        for (BstEntry entry : this.entries) {
            f.execute(entry);
        }
    }

    private void sort() {
        Collections.sort(this.entries, (o1, o2) -> ((String)((BstEntry)o1).localStrings.get("sort.key$")).compareTo((String)((BstEntry)o2).localStrings.get("sort.key$")));
    }

    private void executeInContext(Object o, BstEntry context) {
        if (o instanceof Tree) {
            Tree t = (Tree)o;
            new StackFunction(t).execute(context);
        } else if (o instanceof Identifier) {
            this.execute(((Identifier)o).getName(), context);
        }
    }

    private void execute(Tree child) {
        this.execute(child.getChild(0).getText(), null);
    }

    private void push(Tree t) {
        this.stack.push(t);
    }

    private void execute(String name, BstEntry context) {
        if (context != null) {
            if (context.getFields().containsKey(name)) {
                this.stack.push(context.getFields().get(name));
                return;
            }
            if (context.localStrings.containsKey(name)) {
                this.stack.push(context.localStrings.get(name));
                return;
            }
            if (context.localIntegers.containsKey(name)) {
                this.stack.push(context.localIntegers.get(name));
                return;
            }
        }
        if (this.strings.containsKey(name)) {
            this.stack.push(this.strings.get(name));
            return;
        }
        if (this.integers.containsKey(name)) {
            this.stack.push(this.integers.get(name));
            return;
        }
        if (this.functions.containsKey(name)) {
            this.functions.get(name).execute(context);
            return;
        }
        throw new VMException("No matching identifier found: " + name);
    }

    private void function(Tree child) {
        String name = child.getChild(0).getText();
        Tree localStack = child.getChild(1);
        this.functions.put(name, new StackFunction(localStack));
    }

    private void integers(Tree child) {
        Tree t = child.getChild(0);
        for (int i = 0; i < t.getChildCount(); ++i) {
            String name = t.getChild(i).getText();
            this.integers.put(name, 0);
        }
    }

    private void strings(Tree child) {
        Tree t = child.getChild(0);
        for (int i = 0; i < t.getChildCount(); ++i) {
            String name = t.getChild(i).getText();
            this.strings.put(name, null);
        }
    }

    private void push(Integer integer) {
        this.stack.push(integer);
    }

    private void push(String string) {
        this.stack.push(string);
    }

    private void push(Identifier identifier) {
        this.stack.push(identifier);
    }

    public Map<String, String> getStrings() {
        return this.strings;
    }

    public Map<String, Integer> getIntegers() {
        return this.integers;
    }

    public List<BstEntry> getEntries() {
        return this.entries;
    }

    public Map<String, BstFunction> getFunctions() {
        return this.functions;
    }

    public Stack<Object> getStack() {
        return this.stack;
    }

    @Override
    public void warn(String string) {
        LOGGER.warn(string);
    }

    public static class BstEntry {
        private final BibEntry entry;
        private final Map<String, String> localStrings = new HashMap<String, String>();
        private final Map<String, String> fields = new HashMap<String, String>();
        private final Map<String, Integer> localIntegers = new HashMap<String, Integer>();

        public BstEntry(BibEntry e) {
            this.entry = e;
        }

        public Map<String, String> getFields() {
            return this.fields;
        }

        public BibEntry getBibtexEntry() {
            return this.entry;
        }
    }

    public class StackFunction
    implements BstFunction {
        private final Tree localTree;

        public StackFunction(Tree stack) {
            this.localTree = stack;
        }

        public Tree getTree() {
            return this.localTree;
        }

        @Override
        public void execute(BstEntry context) {
            for (int i = 0; i < this.localTree.getChildCount(); ++i) {
                Tree c = this.localTree.getChild(i);
                try {
                    switch (c.getType()) {
                        case 22: {
                            String s = c.getText();
                            VM.this.push(s.substring(1, s.length() - 1));
                            break;
                        }
                        case 10: {
                            VM.this.push(Integer.parseInt(c.getText().substring(1)));
                            break;
                        }
                        case 17: {
                            VM.this.push(new Identifier(c.getText().substring(1)));
                            break;
                        }
                        case 21: {
                            VM.this.push(c);
                            break;
                        }
                        default: {
                            VM.this.execute(c.getText(), context);
                            break;
                        }
                    }
                    continue;
                }
                catch (VMException e) {
                    if (VM.this.file == null) {
                        LOGGER.error("ERROR " + e.getMessage() + " (" + c.getLine() + ")");
                    } else {
                        LOGGER.error("ERROR " + e.getMessage() + " (" + VM.this.file.getPath() + ":" + c.getLine() + ")");
                    }
                    throw e;
                }
            }
        }
    }

    public class MacroFunction
    implements BstFunction {
        private final String replacement;

        public MacroFunction(String replacement) {
            this.replacement = replacement;
        }

        @Override
        public void execute(BstEntry context) {
            VM.this.push(this.replacement);
        }
    }

    @FunctionalInterface
    public static interface BstFunction {
        public void execute(BstEntry var1);
    }

    public static class Variable {
        public final String name;

        public Variable(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Identifier {
        public final String name;

        public Identifier(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

