/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.bst;

import java.util.Stack;
import net.sf.jabref.logic.bst.BibtexTextPrefix;
import net.sf.jabref.logic.bst.VM;
import net.sf.jabref.logic.bst.VMException;

public class TextPrefixFunction
implements VM.BstFunction {
    private final VM vm;

    public TextPrefixFunction(VM vm) {
        this.vm = vm;
    }

    @Override
    public void execute(VM.BstEntry context) {
        Stack<Object> stack = this.vm.getStack();
        if (stack.size() < 2) {
            throw new VMException("Not enough operands on stack for operation text.prefix$");
        }
        Object o1 = stack.pop();
        if (!(o1 instanceof Integer)) {
            this.vm.warn("An integer is needed as first parameter to text.prefix$");
            stack.push("");
            return;
        }
        Object o2 = stack.pop();
        if (!(o2 instanceof String)) {
            this.vm.warn("A string is needed as second parameter to text.prefix$");
            stack.push("");
            return;
        }
        stack.push(BibtexTextPrefix.textPrefix((Integer)o1, (String)o2, this.vm));
    }
}

