/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.bst;

import java.util.Stack;
import net.sf.jabref.logic.bst.BibtexPurify;
import net.sf.jabref.logic.bst.VM;
import net.sf.jabref.logic.bst.VMException;

public class PurifyFunction
implements VM.BstFunction {
    private final VM vm;

    public PurifyFunction(VM vm) {
        this.vm = vm;
    }

    @Override
    public void execute(VM.BstEntry context) {
        Stack<Object> stack = this.vm.getStack();
        if (stack.isEmpty()) {
            throw new VMException("Not enough operands on stack for operation purify$");
        }
        Object o1 = stack.pop();
        if (!(o1 instanceof String)) {
            this.vm.warn("A string is needed for purify$");
            stack.push("");
            return;
        }
        stack.push(BibtexPurify.purify((String)o1, this.vm));
    }
}

