/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.bst;

import java.util.Stack;
import net.sf.jabref.logic.bst.BibtexCaseChanger;
import net.sf.jabref.logic.bst.VM;
import net.sf.jabref.logic.bst.VMException;

public class ChangeCaseFunction
implements VM.BstFunction {
    private final VM vm;

    public ChangeCaseFunction(VM vm) {
        this.vm = vm;
    }

    @Override
    public void execute(VM.BstEntry context) {
        Stack<Object> stack = this.vm.getStack();
        if (stack.size() < 2) {
            throw new VMException("Not enough operands on stack for operation change.case$");
        }
        Object o1 = stack.pop();
        if (!(o1 instanceof String) || ((String)o1).length() != 1) {
            throw new VMException("A format string of length 1 is needed for change.case$");
        }
        Object o2 = stack.pop();
        if (!(o2 instanceof String)) {
            throw new VMException("A string is needed as second parameter for change.case$");
        }
        char format = ((String)o1).toLowerCase().charAt(0);
        String s = (String)o2;
        stack.push(BibtexCaseChanger.changeCase(s, BibtexCaseChanger.FORMAT_MODE.getFormatModeForBSTFormat(format)));
    }
}

