/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.bibtexkeypattern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.logic.bibtexkeypattern.BibtexKeyPatternPreferences;
import net.sf.jabref.logic.formatter.Formatters;
import net.sf.jabref.logic.formatter.casechanger.Word;
import net.sf.jabref.logic.layout.format.RemoveLatexCommandsFormatter;
import net.sf.jabref.model.bibtexkeypattern.AbstractBibtexKeyPattern;
import net.sf.jabref.model.cleanup.Formatter;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.AuthorList;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.Keyword;
import net.sf.jabref.model.entry.KeywordList;
import net.sf.jabref.model.strings.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BibtexKeyPatternUtil {
    private static final Log LOGGER = LogFactory.getLog(BibtexKeyPatternUtil.class);
    private static final String STARTING_CAPITAL_PATTERN = "[^A-Z]";
    private static final String CHARS = "abcdefghijklmnopqrstuvwxyz";
    private static final Pattern REGEX_PATTERN = Pattern.compile(".*\\(\\{([A-Z]+)\\}\\).*");
    private static final int CHARS_OF_FIRST = 5;
    private static BibDatabase database;

    public static void setDataBase(BibDatabase db) {
        database = db;
    }

    private static String normalize(String content) {
        ArrayList<String> tokens = new ArrayList<String>();
        int b = 0;
        StringBuilder and = new StringBuilder();
        StringBuilder token = new StringBuilder();
        for (int p = 0; p < content.length(); ++p) {
            if (b == 0) {
                String andString = and.toString();
                if (andString.isEmpty() && content.charAt(p) == ' ' || " ".equals(andString) && content.charAt(p) == 'a' || " a".equals(andString) && content.charAt(p) == 'n' || " an".equals(andString) && content.charAt(p) == 'd') {
                    and.append(content.charAt(p));
                    continue;
                }
                if (" and".equals(and.toString()) && content.charAt(p) == ' ') {
                    and = new StringBuilder();
                    tokens.add(token.toString().trim());
                    token = new StringBuilder();
                    continue;
                }
                if (content.charAt(p) == '{') {
                    ++b;
                }
                if (content.charAt(p) == '}') {
                    --b;
                }
                token.append((CharSequence)and);
                and = new StringBuilder();
                token.append(content.charAt(p));
                continue;
            }
            token.append(content.charAt(p));
        }
        tokens.add(token.toString());
        StringBuilder normalized = new StringBuilder("");
        for (int i = 0; i < tokens.size(); ++i) {
            if (i > 0) {
                normalized.append(" and ");
            }
            normalized.append(BibtexKeyPatternUtil.isInstitution((String)tokens.get(i)) ? BibtexKeyPatternUtil.generateInstitutionKey((String)tokens.get(i)) : BibtexKeyPatternUtil.removeDiacritics((String)tokens.get(i)));
        }
        return normalized.toString();
    }

    private static String removeDiacritics(String content) {
        if (content.isEmpty()) {
            return content;
        }
        String result = content;
        result = result.replaceAll("\\{\\\\\"([a-zA-Z])\\}", "$1e");
        result = result.replaceAll("\\\\\"\\{([a-zA-Z])\\}", "$1e");
        result = result.replaceAll("\\\\\"([a-zA-Z])", "$1e");
        result = result.replaceAll("\\{\\\\.([a-zA-Z])\\}", "$1");
        result = result.replaceAll("\\\\.\\{([a-zA-Z])\\}", "$1");
        result = result.replaceAll("\\\\.([a-zA-Z])", "$1");
        return result;
    }

    private static String unifyDiacritics(String content) {
        return content.replaceAll("\\$\\\\ddot\\{\\\\mathrm\\{([^\\}])\\}\\}\\$", "{\\\"$1}").replaceAll("(\\\\[^\\-a-zA-Z])\\{?([a-zA-Z])\\}?", "{$1$2}");
    }

    private static boolean isInstitution(String author) {
        return StringUtil.isInCurlyBrackets(author);
    }

    private static String generateInstitutionKey(String content) {
        if (content.isEmpty()) {
            return content;
        }
        String result = content;
        result = BibtexKeyPatternUtil.unifyDiacritics(result);
        Matcher matcher = REGEX_PATTERN.matcher(result = result.replaceAll("^\\{", "").replaceAll("\\}$", ""));
        if (matcher.matches()) {
            return matcher.group(1);
        }
        result = BibtexKeyPatternUtil.removeDiacritics(result);
        String[] parts = result.split(",");
        String university = null;
        String department = null;
        String school = null;
        String rest = null;
        List<String> ignore = Arrays.asList("press", "the");
        for (int index = 0; index < parts.length; ++index) {
            ArrayList<String> part = new ArrayList<String>();
            for (String k : parts[index].replaceAll("\\{[A-Z]+\\}", "").split("[ \\-_]")) {
                if ((k.isEmpty() || ignore.contains(k.toLowerCase(Locale.ENGLISH)) || k.charAt(k.length() - 1) == '.' || !String.valueOf(k.charAt(0)).matches("[A-Z]")) && (k.length() < 3 || !"uni".equalsIgnoreCase(k.substring(0, 2)))) continue;
                part.add(k);
            }
            boolean isUniversity = false;
            boolean isTechnology = false;
            boolean isDepartment = false;
            boolean isSchool = false;
            for (String string : part) {
                if (string.matches("^[Uu][Nn][Ii].*")) {
                    isUniversity = true;
                }
                if (string.matches("^[Tt][Ee][Cc][Hh].*")) {
                    isTechnology = true;
                }
                if ("school".equalsIgnoreCase(string)) {
                    isSchool = true;
                }
                if (!string.matches("^[Dd][EeIi][Pp].*") && !string.matches("^[Ll][Aa][Bb].*")) continue;
                isDepartment = true;
            }
            if (isTechnology) {
                isUniversity = false;
            }
            if (isUniversity) {
                StringBuilder universitySB = new StringBuilder();
                universitySB.append("Uni");
                for (String string : part) {
                    if (string.matches("^[Uu][Nn][Ii].*")) continue;
                    universitySB.append(string);
                }
                university = universitySB.toString();
                if (index <= 0 || department != null) continue;
                department = parts[index - 1];
                continue;
            }
            if (isSchool || isDepartment) {
                StringBuilder schoolSB = new StringBuilder();
                StringBuilder stringBuilder = new StringBuilder();
                for (String k : part) {
                    if (k.matches("^[Dd][EeIi][Pp].*") || "school".equalsIgnoreCase(k) || "faculty".equalsIgnoreCase(k) || k.replaceAll(STARTING_CAPITAL_PATTERN, "").isEmpty()) continue;
                    if (isSchool) {
                        schoolSB.append(k.replaceAll(STARTING_CAPITAL_PATTERN, ""));
                    }
                    if (!isDepartment) continue;
                    stringBuilder.append(k.replaceAll(STARTING_CAPITAL_PATTERN, ""));
                }
                if (isSchool) {
                    school = schoolSB.toString();
                }
                if (!isDepartment) continue;
                department = stringBuilder.toString();
                continue;
            }
            if (rest != null) continue;
            StringBuilder restSB = new StringBuilder();
            if (part.size() < 3) {
                for (String string : part) {
                    restSB.append(string);
                }
            } else {
                for (String string : part) {
                    String string2 = string.replaceAll(STARTING_CAPITAL_PATTERN, "");
                    if (string2.isEmpty()) continue;
                    restSB.append(string2);
                }
            }
            rest = restSB.toString();
        }
        return (university == null ? rest : university) + (school == null ? "" : school) + (department == null || school != null && department.equals(school) ? "" : department);
    }

    public static void makeLabel(AbstractBibtexKeyPattern citeKeyPattern, BibDatabase dBase, BibEntry entry, BibtexKeyPatternPreferences bibtexKeyPatternPreferences) {
        database = dBase;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String entryType = entry.getType();
            ArrayList<String> typeList = new ArrayList<String>(citeKeyPattern.getValue(entryType));
            if (!typeList.isEmpty()) {
                typeList.remove(0);
            }
            boolean field = false;
            for (String typeListEntry : typeList) {
                if ("[".equals(typeListEntry)) {
                    field = true;
                    continue;
                }
                if ("]".equals(typeListEntry)) {
                    field = false;
                    continue;
                }
                if (field) {
                    List<String> parts = BibtexKeyPatternUtil.parseFieldMarker(typeListEntry);
                    String label = BibtexKeyPatternUtil.makeLabel(entry, parts.get(0), bibtexKeyPatternPreferences.getKeywordDelimiter());
                    if (parts.size() > 1) {
                        label = BibtexKeyPatternUtil.applyModifiers(label, parts, 1);
                    }
                    stringBuilder.append(label);
                    continue;
                }
                stringBuilder.append(typeListEntry);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot make label", e);
        }
        String key = BibtexKeyPatternUtil.checkLegalKey(stringBuilder.toString(), bibtexKeyPatternPreferences.isEnforceLegalKey());
        String regex = bibtexKeyPatternPreferences.getKeyPatternRegex();
        if (regex != null && !regex.trim().isEmpty()) {
            String replacement = bibtexKeyPatternPreferences.getKeyPatternReplacement();
            key = key.replaceAll(regex, replacement);
        }
        String oldKey = entry.getCiteKeyOptional().orElse(null);
        int occurrences = database.getDuplicationChecker().getNumberOfKeyOccurrences(key);
        if (Objects.equals(oldKey, key)) {
            --occurrences;
        }
        boolean alwaysAddLetter = bibtexKeyPatternPreferences.isAlwaysAddLetter();
        boolean firstLetterA = bibtexKeyPatternPreferences.isFirstLetterA();
        if (!alwaysAddLetter && occurrences == 0) {
            entry.setCiteKey(key);
        } else {
            String moddedKey;
            int number = !alwaysAddLetter && !firstLetterA ? 1 : 0;
            do {
                moddedKey = key + BibtexKeyPatternUtil.getAddition(number);
                ++number;
                occurrences = database.getDuplicationChecker().getNumberOfKeyOccurrences(moddedKey);
                if (!Objects.equals(oldKey, moddedKey)) continue;
                --occurrences;
            } while (occurrences > 0);
            entry.setCiteKey(moddedKey);
        }
    }

    public static String applyModifiers(String label, List<String> parts, int offset) {
        String resultingLabel = label;
        if (parts.size() > offset) {
            for (int j = offset; j < parts.size(); ++j) {
                String modifier = parts.get(j);
                if ("abbr".equals(modifier)) {
                    String[] words;
                    StringBuilder abbreviateSB = new StringBuilder();
                    for (String word : words = resultingLabel.replaceAll("[\\{\\}']", "").split("[\\(\\) \r\n\"]")) {
                        if (word.isEmpty()) continue;
                        abbreviateSB.append(word.charAt(0));
                    }
                    resultingLabel = abbreviateSB.toString();
                    continue;
                }
                Optional<Formatter> formatter = Formatters.getFormatterForModifier(modifier);
                if (formatter.isPresent()) {
                    resultingLabel = formatter.get().format(label);
                    continue;
                }
                if (!modifier.isEmpty() && modifier.length() >= 2 && modifier.charAt(0) == '(' && modifier.endsWith(")")) {
                    if (label.isEmpty() && modifier.length() > 2) {
                        resultingLabel = modifier.substring(1, modifier.length() - 1);
                        continue;
                    }
                    resultingLabel = label;
                    continue;
                }
                LOGGER.info("Key generator warning: unknown modifier '" + modifier + "'.");
                resultingLabel = label;
            }
        }
        return resultingLabel;
    }

    public static String makeLabel(BibEntry entry, String value, Character keywordDelimiter) {
        String val = value;
        try {
            if (val.startsWith("auth") || val.startsWith("pureauth")) {
                String authString = entry.getField("author").map(authorString -> BibtexKeyPatternUtil.normalize(database.resolveForStrings((String)authorString))).orElse("");
                if (val.startsWith("pure")) {
                    val = val.substring(4);
                }
                if (authString.isEmpty()) {
                    authString = entry.getField("editor").map(authorString -> BibtexKeyPatternUtil.normalize(database.resolveForStrings((String)authorString))).orElse("");
                }
                if ("auth".equals(val)) {
                    return BibtexKeyPatternUtil.firstAuthor(authString);
                }
                if ("authForeIni".equals(val)) {
                    return BibtexKeyPatternUtil.firstAuthorForenameInitials(authString);
                }
                if ("authFirstFull".equals(val)) {
                    return BibtexKeyPatternUtil.firstAuthorVonAndLast(authString);
                }
                if ("authors".equals(val)) {
                    return BibtexKeyPatternUtil.allAuthors(authString);
                }
                if ("authorsAlpha".equals(val)) {
                    return BibtexKeyPatternUtil.authorsAlpha(authString);
                }
                if ("authorLast".equals(val)) {
                    return BibtexKeyPatternUtil.lastAuthor(authString);
                }
                if ("authorLastForeIni".equals(val)) {
                    return BibtexKeyPatternUtil.lastAuthorForenameInitials(authString);
                }
                if ("authorIni".equals(val)) {
                    return BibtexKeyPatternUtil.oneAuthorPlusIni(authString);
                }
                if (val.matches("authIni[\\d]+")) {
                    int num = Integer.parseInt(val.substring(7));
                    return BibtexKeyPatternUtil.authIniN(authString, num);
                }
                if ("auth.auth.ea".equals(val)) {
                    return BibtexKeyPatternUtil.authAuthEa(authString);
                }
                if ("auth.etal".equals(val)) {
                    return BibtexKeyPatternUtil.authEtal(authString, ".", ".etal");
                }
                if ("authEtAl".equals(val)) {
                    return BibtexKeyPatternUtil.authEtal(authString, "", "EtAl");
                }
                if ("authshort".equals(val)) {
                    return BibtexKeyPatternUtil.authshort(authString);
                }
                if (val.matches("auth[\\d]+_[\\d]+")) {
                    String[] nums = val.substring(4).split("_");
                    return BibtexKeyPatternUtil.authNofMth(authString, Integer.parseInt(nums[0]), Integer.parseInt(nums[1]));
                }
                if (val.matches("auth\\d+")) {
                    String fa = BibtexKeyPatternUtil.firstAuthor(authString);
                    int num = Integer.parseInt(val.substring(4));
                    if (num > fa.length()) {
                        num = fa.length();
                    }
                    return fa.substring(0, num);
                }
                if (val.matches("authors\\d+")) {
                    return BibtexKeyPatternUtil.nAuthors(authString, Integer.parseInt(val.substring(7)));
                }
                return entry.getFieldOrAlias(val).orElse("");
            }
            if (val.startsWith("ed")) {
                if ("edtr".equals(val)) {
                    return BibtexKeyPatternUtil.firstAuthor(entry.getField("editor").orElse(""));
                }
                if ("edtrForeIni".equals(val)) {
                    return BibtexKeyPatternUtil.firstAuthorForenameInitials(entry.getField("editor").orElse(""));
                }
                if ("editors".equals(val)) {
                    return BibtexKeyPatternUtil.allAuthors(entry.getField("editor").orElse(""));
                }
                if ("editorLast".equals(val)) {
                    return BibtexKeyPatternUtil.lastAuthor(entry.getField("editor").orElse(""));
                }
                if ("editorLastForeIni".equals(val)) {
                    return BibtexKeyPatternUtil.lastAuthorForenameInitials(entry.getField("editor").orElse(""));
                }
                if ("editorIni".equals(val)) {
                    return BibtexKeyPatternUtil.oneAuthorPlusIni(entry.getField("editor").orElse(""));
                }
                if (val.matches("edtrIni[\\d]+")) {
                    int num = Integer.parseInt(val.substring(7));
                    return BibtexKeyPatternUtil.authIniN(entry.getField("editor").orElse(""), num);
                }
                if (val.matches("edtr[\\d]+_[\\d]+")) {
                    String[] nums = val.substring(4).split("_");
                    return BibtexKeyPatternUtil.authNofMth(entry.getField("editor").orElse(""), Integer.parseInt(nums[0]), Integer.parseInt(nums[1]) - 1);
                }
                if ("edtr.edtr.ea".equals(val)) {
                    return BibtexKeyPatternUtil.authAuthEa(entry.getField("editor").orElse(""));
                }
                if ("edtrshort".equals(val)) {
                    return BibtexKeyPatternUtil.authshort(entry.getField("editor").orElse(""));
                }
                if (val.matches("edtr\\d+")) {
                    String fa = BibtexKeyPatternUtil.firstAuthor(entry.getField("editor").orElse(""));
                    int num = Integer.parseInt(val.substring(4));
                    if (num > fa.length()) {
                        num = fa.length();
                    }
                    return fa.substring(0, num);
                }
                return entry.getFieldOrAlias(val).orElse("");
            }
            if ("firstpage".equals(val)) {
                return BibtexKeyPatternUtil.firstPage(entry.getField("pages").orElse(""));
            }
            if ("lastpage".equals(val)) {
                return BibtexKeyPatternUtil.lastPage(entry.getField("pages").orElse(""));
            }
            if ("shorttitle".equals(val)) {
                return BibtexKeyPatternUtil.getTitleWords(3, entry.getField("title").orElse(""));
            }
            if ("shorttitleINI".equals(val)) {
                return BibtexKeyPatternUtil.keepLettersAndDigitsOnly(BibtexKeyPatternUtil.applyModifiers(BibtexKeyPatternUtil.getTitleWordsWithSpaces(3, entry.getField("title").orElse("")), Collections.singletonList("abbr"), 0));
            }
            if ("veryshorttitle".equals(val)) {
                return BibtexKeyPatternUtil.getTitleWords(1, entry.getField("title").orElse(""));
            }
            if ("shortyear".equals(val)) {
                String yearString = entry.getFieldOrAlias("year").orElse("");
                if (yearString.isEmpty()) {
                    return yearString;
                }
                if (yearString.startsWith("in") || yearString.startsWith("sub")) {
                    return "IP";
                }
                if (yearString.length() > 2) {
                    return yearString.substring(yearString.length() - 2);
                }
                return yearString;
            }
            if (val.matches("keyword\\d+")) {
                int num = Integer.parseInt(val.substring(7));
                KeywordList separatedKeywords = entry.getKeywords(keywordDelimiter);
                if (separatedKeywords.size() < num) {
                    return "";
                }
                return separatedKeywords.get(num - 1).toString();
            }
            if (val.matches("keywords\\d*")) {
                int num = val.length() > 8 ? Integer.parseInt(val.substring(8)) : Integer.MAX_VALUE;
                KeywordList separatedKeywords = entry.getKeywords(keywordDelimiter);
                StringBuilder sb = new StringBuilder();
                int i = 0;
                for (Keyword keyword : separatedKeywords) {
                    sb.append(keyword.toString().replaceAll("\\s+", ""));
                    if (++i < num) continue;
                    break;
                }
                return sb.toString();
            }
            return entry.getFieldOrAlias(val).orElse("");
        }
        catch (NullPointerException ex) {
            LOGGER.debug("Problem making label", ex);
            return "";
        }
    }

    private static String getAddition(int number) {
        if (number >= CHARS.length()) {
            int lastChar = number % CHARS.length();
            return BibtexKeyPatternUtil.getAddition(number / CHARS.length() - 1) + CHARS.substring(lastChar, lastChar + 1);
        }
        return CHARS.substring(number, number + 1);
    }

    public static String getTitleWords(int number, String title) {
        return BibtexKeyPatternUtil.keepLettersAndDigitsOnly(BibtexKeyPatternUtil.getTitleWordsWithSpaces(number, title));
    }

    private static String getTitleWordsWithSpaces(int number, String title) {
        String ss = new RemoveLatexCommandsFormatter().format(title);
        StringBuilder stringBuilder = new StringBuilder();
        int piv = 0;
        int words = 0;
        block0: while (piv < ss.length() && words < number) {
            StringBuilder current = new StringBuilder();
            while (piv < ss.length() && !Character.isWhitespace(ss.charAt(piv)) && ss.charAt(piv) != '-') {
                current.append(ss.charAt(piv));
                ++piv;
            }
            ++piv;
            String word = current.toString().trim();
            if (word.isEmpty()) continue;
            for (String smallWord : Word.SMALLER_WORDS) {
                if (!word.equalsIgnoreCase(smallWord)) continue;
                continue block0;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(word);
            ++words;
        }
        return stringBuilder.toString();
    }

    private static String keepLettersAndDigitsOnly(String in) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            if (!Character.isLetterOrDigit(in.charAt(i))) continue;
            stringBuilder.append(in.charAt(i));
        }
        return stringBuilder.toString();
    }

    public static String firstAuthor(String authorField) {
        AuthorList authorList = AuthorList.parse(authorField);
        if (authorList.isEmpty()) {
            return "";
        }
        return authorList.getAuthor(0).getLast().orElse("");
    }

    public static String firstAuthorForenameInitials(String authorField) {
        AuthorList authorList = AuthorList.parse(authorField);
        if (authorList.isEmpty()) {
            return "";
        }
        return authorList.getAuthor(0).getFirstAbbr().map(s -> s.substring(0, 1)).orElse("");
    }

    public static String firstAuthorVonAndLast(String authorField) {
        AuthorList authorList = AuthorList.parse(authorField);
        if (authorList.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        authorList.getAuthor(0).getVon().ifPresent(vonAuthor -> stringBuilder.append(vonAuthor.replaceAll(" ", "")));
        authorList.getAuthor(0).getLast().ifPresent(stringBuilder::append);
        return stringBuilder.toString();
    }

    public static String lastAuthor(String authorField) {
        String[] tokens = AuthorList.fixAuthorForAlphabetization(authorField).split("\\s+\\band\\b\\s+");
        if (tokens.length > 0) {
            String[] lastAuthor = tokens[tokens.length - 1].split(",");
            return lastAuthor[0];
        }
        return "";
    }

    public static String lastAuthorForenameInitials(String authorField) {
        AuthorList authorList = AuthorList.parse(authorField);
        if (authorList.isEmpty()) {
            return "";
        }
        return authorList.getAuthor(authorList.getNumberOfAuthors() - 1).getFirstAbbr().map(s -> s.substring(0, 1)).orElse("");
    }

    public static String allAuthors(String authorField) {
        return BibtexKeyPatternUtil.nAuthors(authorField, Integer.MAX_VALUE);
    }

    public static String authorsAlpha(String authorField) {
        int max;
        String authors = "";
        String fixedAuthors = AuthorList.fixAuthorLastNameOnlyCommas(authorField, false);
        String[] tokens = (fixedAuthors = fixedAuthors.replace(" and ", ", ")).split(",");
        int n = max = tokens.length > 4 ? 3 : tokens.length;
        if (max == 1) {
            String[] firstAuthor = tokens[0].replaceAll("\\s+", " ").trim().split(" ");
            for (int j = 0; j < firstAuthor.length - 1; ++j) {
                authors = authors.concat(firstAuthor[j].substring(0, 1));
            }
            authors = authors.concat(firstAuthor[firstAuthor.length - 1].substring(0, Math.min(3, firstAuthor[firstAuthor.length - 1].length())));
        } else {
            for (int i = 0; i < max; ++i) {
                String[] curAuthor;
                for (String aCurAuthor : curAuthor = tokens[i].replaceAll("\\s+", " ").trim().split(" ")) {
                    authors = authors.concat(aCurAuthor.substring(0, 1));
                }
            }
            if (tokens.length > 4) {
                authors = authors.concat("+");
            }
        }
        return authors;
    }

    public static String nAuthors(String authorField, int n) {
        String[] tokens = AuthorList.fixAuthorForAlphabetization(authorField).split("\\s+\\band\\b\\s+");
        StringBuilder authorSB = new StringBuilder();
        for (int i = 0; tokens.length > i && i < n; ++i) {
            String lastName = tokens[i].replaceAll(",\\s+.*", "");
            authorSB.append(lastName);
        }
        if (tokens.length > n) {
            authorSB.append("EtAl");
        }
        return authorSB.toString();
    }

    public static String oneAuthorPlusIni(String authorField) {
        String fixedAuthorField = AuthorList.fixAuthorForAlphabetization(authorField);
        String[] tokens = fixedAuthorField.split("\\s+\\band\\b\\s+");
        if (tokens.length == 0) {
            return "";
        }
        String firstAuthor = tokens[0].split(",")[0];
        StringBuilder authorSB = new StringBuilder();
        authorSB.append(firstAuthor.substring(0, Math.min(5, firstAuthor.length())));
        for (int i = 1; tokens.length > i; ++i) {
            authorSB.append(tokens[i].charAt(0));
        }
        return authorSB.toString();
    }

    public static String authAuthEa(String authorField) {
        String fixedAuthorField = AuthorList.fixAuthorForAlphabetization(authorField);
        String[] tokens = fixedAuthorField.split("\\s+\\band\\b\\s+");
        if (tokens.length == 0) {
            return "";
        }
        StringBuilder author = new StringBuilder();
        author.append(tokens[0].split(",")[0]);
        if (tokens.length >= 2) {
            author.append('.').append(tokens[1].split(",")[0]);
        }
        if (tokens.length > 2) {
            author.append(".ea");
        }
        return author.toString();
    }

    public static String authEtal(String authorField, String delim, String append) {
        String fixedAuthorField = AuthorList.fixAuthorForAlphabetization(authorField);
        String[] tokens = fixedAuthorField.split("\\s*\\band\\b\\s*");
        if (tokens.length == 0) {
            return "";
        }
        StringBuilder author = new StringBuilder();
        author.append(tokens[0].split(",")[0]);
        if (tokens.length == 2) {
            author.append(delim).append(tokens[1].split(",")[0]);
        } else if (tokens.length > 2) {
            author.append(append);
        }
        return author.toString();
    }

    public static String authNofMth(String authorField, int n, int m) {
        int mminusone = m - 1;
        String fixedAuthorField = AuthorList.fixAuthorForAlphabetization(authorField);
        String[] tokens = fixedAuthorField.split("\\s+\\band\\b\\s+");
        if (tokens.length <= mminusone || n < 0 || mminusone < 0) {
            return "";
        }
        String lastName = tokens[mminusone].split(",")[0];
        if (lastName.length() <= n) {
            return lastName;
        }
        return lastName.substring(0, n);
    }

    public static String authshort(String authorField) {
        String fixedAuthorField = AuthorList.fixAuthorForAlphabetization(authorField);
        StringBuilder author = new StringBuilder();
        String[] tokens = fixedAuthorField.split("\\band\\b");
        if (tokens.length == 1) {
            author.append(BibtexKeyPatternUtil.authNofMth(fixedAuthorField, fixedAuthorField.length(), 1));
        } else if (tokens.length >= 2) {
            for (int i = 0; tokens.length > i && i < 3; ++i) {
                author.append(BibtexKeyPatternUtil.authNofMth(fixedAuthorField, 1, i + 1));
            }
            if (tokens.length > 3) {
                author.append('+');
            }
        }
        return author.toString();
    }

    public static String authIniN(String authorField, int n) {
        if (n <= 0) {
            return "";
        }
        String fixedAuthorField = AuthorList.fixAuthorForAlphabetization(authorField);
        StringBuilder author = new StringBuilder();
        String[] tokens = fixedAuthorField.split("\\band\\b");
        if (tokens.length == 0) {
            return author.toString();
        }
        int charsAll = n / tokens.length;
        for (int i = 0; tokens.length > i; ++i) {
            if (i < n % tokens.length) {
                author.append(BibtexKeyPatternUtil.authNofMth(fixedAuthorField, charsAll + 1, i + 1));
                continue;
            }
            author.append(BibtexKeyPatternUtil.authNofMth(fixedAuthorField, charsAll, i + 1));
        }
        if (author.length() <= n) {
            return author.toString();
        }
        return author.toString().substring(0, n);
    }

    public static String firstPage(String pages) {
        String[] splitPages = pages.split("\\D+");
        int result = Integer.MAX_VALUE;
        for (String n : splitPages) {
            if (!n.matches("\\d+")) continue;
            result = Math.min(Integer.parseInt(n), result);
        }
        if (result == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(result);
    }

    public static String lastPage(String pages) {
        String[] splitPages = pages.split("\\D+");
        int result = Integer.MIN_VALUE;
        for (String n : splitPages) {
            if (!n.matches("\\d+")) continue;
            result = Math.max(Integer.parseInt(n), result);
        }
        if (result == Integer.MIN_VALUE) {
            return "";
        }
        return String.valueOf(result);
    }

    private static List<String> parseFieldMarker(String arg) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean escaped = false;
        int inParenthesis = 0;
        for (int i = 0; i < arg.length(); ++i) {
            char currentChar = arg.charAt(i);
            if (currentChar == ':' && !escaped && inParenthesis == 0) {
                parts.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            if (currentChar == '(' && !escaped) {
                ++inParenthesis;
                current.append(currentChar);
                continue;
            }
            if (currentChar == ')' && !escaped && inParenthesis > 0) {
                --inParenthesis;
                current.append(currentChar);
                continue;
            }
            if (currentChar == '\\') {
                if (escaped) {
                    escaped = false;
                    current.append(currentChar);
                    continue;
                }
                escaped = true;
                continue;
            }
            if (escaped) {
                current.append(currentChar);
                escaped = false;
                continue;
            }
            current.append(currentChar);
        }
        parts.add(current.toString());
        return parts;
    }

    public static String checkLegalKey(String key, boolean enforceLegalKey) {
        if (key == null) {
            return null;
        }
        if (!enforceLegalKey) {
            StringBuilder newKey = new StringBuilder();
            for (int i = 0; i < key.length(); ++i) {
                char c = key.charAt(i);
                if (Character.isWhitespace(c) || "{}(),\\\"".indexOf(c) != -1) continue;
                newKey.append(c);
            }
            return newKey.toString();
        }
        StringBuilder newKey = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (Character.isWhitespace(c) || "{}(),\\\"#~^'".indexOf(c) != -1) continue;
            newKey.append(c);
        }
        return StringUtil.replaceSpecialCharacters(newKey.toString());
    }
}

