/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.bibtex.comparator;

import java.util.Comparator;
import java.util.Objects;
import net.sf.jabref.model.entry.AuthorList;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.FieldProperty;
import net.sf.jabref.model.entry.InternalBibtexFields;

public class EntryComparator
implements Comparator<BibEntry> {
    private final String sortField;
    private final boolean descending;
    private final boolean binary;
    private final boolean numeric;
    private final Comparator<BibEntry> next;

    public EntryComparator(boolean binary, boolean descending, String field, Comparator<BibEntry> next) {
        this.binary = binary;
        this.sortField = field;
        this.descending = descending;
        this.next = next;
        this.numeric = InternalBibtexFields.isNumeric(this.sortField);
    }

    public EntryComparator(boolean binary, boolean descending, String field) {
        this.binary = binary;
        this.sortField = field;
        this.descending = descending;
        this.next = null;
        this.numeric = InternalBibtexFields.isNumeric(this.sortField);
    }

    @Override
    public int compare(BibEntry e1, BibEntry e2) {
        int result;
        if (Objects.equals(e1, e2)) {
            return 0;
        }
        Object f1 = e1.getField(this.sortField).orElse(null);
        Object f2 = e2.getField(this.sortField).orElse(null);
        if (this.binary) {
            if (f1 == null) {
                return f2 == null ? (this.next == null ? EntryComparator.idCompare(e1, e2) : this.next.compare(e1, e2)) : 1;
            }
            return f2 == null ? -1 : (this.next == null ? EntryComparator.idCompare(e1, e2) : this.next.compare(e1, e2));
        }
        if (InternalBibtexFields.getFieldProperties(this.sortField).contains((Object)FieldProperty.PERSON_NAMES)) {
            if (f1 != null) {
                f1 = AuthorList.fixAuthorForAlphabetization((String)f1).toLowerCase();
            }
            if (f2 != null) {
                f2 = AuthorList.fixAuthorForAlphabetization((String)f2).toLowerCase();
            }
        } else if (this.sortField.equals("entrytype")) {
            f1 = e1.getType();
            f2 = e2.getType();
        } else if (this.numeric) {
            try {
                Integer i1 = Integer.parseInt((String)f1);
                Integer i2 = Integer.parseInt((String)f2);
                f1 = i1;
                f2 = i2;
            }
            catch (NumberFormatException i1) {
                // empty catch block
            }
        }
        if (f2 == null) {
            if (f1 == null) {
                return this.next == null ? EntryComparator.idCompare(e1, e2) : this.next.compare(e1, e2);
            }
            return -1;
        }
        if (f1 == null) {
            return 1;
        }
        if (f1 instanceof Integer && f2 instanceof Integer) {
            result = -((Integer)f1).compareTo((Integer)f2);
        } else if (f2 instanceof Integer) {
            Integer f1AsInteger = Integer.valueOf(f1.toString());
            result = -f1AsInteger.compareTo((Integer)f2);
        } else if (f1 instanceof Integer) {
            Integer f2AsInteger = Integer.valueOf(f2.toString());
            result = -((Integer)f1).compareTo(f2AsInteger);
        } else {
            String ours = ((String)f1).toLowerCase();
            String theirs = ((String)f2).toLowerCase();
            int comp = ours.compareTo(theirs);
            result = -comp;
        }
        if (result != 0) {
            return this.descending ? result : -result;
        }
        if (this.next == null) {
            return EntryComparator.idCompare(e1, e2);
        }
        return this.next.compare(e1, e2);
    }

    private static int idCompare(BibEntry b1, BibEntry b2) {
        return b1.getId().compareTo(b2.getId());
    }
}

