/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.bibtex.comparator;

import java.util.Comparator;
import net.sf.jabref.model.entry.BibtexString;

public class BibtexStringComparator
implements Comparator<BibtexString> {
    private final boolean considerRefs;

    public BibtexStringComparator(boolean considerRefs) {
        this.considerRefs = considerRefs;
    }

    @Override
    public int compare(BibtexString s1, BibtexString s2) {
        String name2;
        String name1 = s1.getName().toLowerCase();
        int res = name1.compareTo(name2 = s2.getName().toLowerCase());
        if (res == 0) {
            return res;
        }
        if (this.considerRefs) {
            BibtexString post;
            BibtexString pre;
            if (res < 0) {
                pre = s1;
                post = s2;
            } else {
                pre = s2;
                post = s1;
            }
            String namePost = post.getName().toLowerCase();
            String textPre = pre.getContent().toLowerCase();
            if (textPre.contains("#" + namePost + "#")) {
                res = -res;
            }
        }
        return res;
    }
}

