/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.bibtex;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.jabref.logic.bibtex.FieldContentParserPreferences;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.model.strings.StringUtil;

public class FieldContentParser {
    private final Set<String> multiLineFields;
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");

    public FieldContentParser(FieldContentParserPreferences prefs) {
        Objects.requireNonNull(prefs);
        this.multiLineFields = new HashSet<String>();
        this.multiLineFields.add("abstract");
        this.multiLineFields.add("review");
        this.multiLineFields.addAll(prefs.getNonWrappableFields());
    }

    public String format(String fieldContent, String bibtexField) {
        if (this.multiLineFields.contains(bibtexField)) {
            return StringUtil.unifyLineBreaks(fieldContent, OS.NEWLINE);
        }
        return WHITESPACE.matcher(fieldContent).replaceAll(" ");
    }

    public String format(StringBuilder fieldContent, String bibtexField) {
        return this.format(fieldContent.toString(), bibtexField);
    }
}

