/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.auxparser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabase;

public class AuxParserResult {
    private final BibDatabase masterDatabase;
    private final Set<String> uniqueKeys = new HashSet<String>();
    private final List<String> unresolvedKeys = new ArrayList<String>();
    private final BibDatabase auxDatabase = new BibDatabase();
    private int nestedAuxCount;
    private int crossRefEntriesCount;

    public AuxParserResult(BibDatabase masterDatabase) {
        this.masterDatabase = masterDatabase;
    }

    public BibDatabase getGeneratedBibDatabase() {
        return this.auxDatabase;
    }

    public List<String> getUnresolvedKeys() {
        return this.unresolvedKeys;
    }

    public int getFoundKeysInAux() {
        return this.uniqueKeys.size();
    }

    public int getResolvedKeysCount() {
        return this.auxDatabase.getEntryCount() - this.crossRefEntriesCount;
    }

    public int getUnresolvedKeysCount() {
        return this.unresolvedKeys.size();
    }

    public int getCrossRefEntriesCount() {
        return this.crossRefEntriesCount;
    }

    public void increaseCrossRefEntriesCounter() {
        ++this.crossRefEntriesCount;
    }

    public void increaseNestedAuxFilesCounter() {
        ++this.nestedAuxCount;
    }

    public String getInformation(boolean includeMissingEntries) {
        StringBuilder result = new StringBuilder();
        result.append(Localization.lang("keys_in_database", new String[0])).append(' ').append(this.masterDatabase.getEntryCount()).append('\n').append(Localization.lang("found_in_AUX_file", new String[0])).append(' ').append(this.getFoundKeysInAux()).append('\n').append(Localization.lang("resolved", new String[0])).append(' ').append(this.getResolvedKeysCount()).append('\n').append(Localization.lang("not_found", new String[0])).append(' ').append(this.getUnresolvedKeysCount()).append('\n').append(Localization.lang("crossreferenced entries included", new String[0])).append(' ').append(this.crossRefEntriesCount).append('\n');
        if (includeMissingEntries && this.getUnresolvedKeysCount() > 0) {
            for (String entry : this.unresolvedKeys) {
                result.append(entry).append('\n');
            }
        }
        if (this.nestedAuxCount > 0) {
            result.append(Localization.lang("nested_AUX_files", new String[0])).append(' ').append(this.nestedAuxCount);
        }
        return result.toString();
    }

    public Set<String> getUniqueKeys() {
        return this.uniqueKeys;
    }
}

