/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.auxparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.logic.auxparser.AuxParserResult;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.IdGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuxParser {
    private static final Log LOGGER = LogFactory.getLog(AuxParser.class);
    private static final Pattern CITE_PATTERN = Pattern.compile("\\\\(citation|abx@aux@cite)\\{(.+)\\}");
    private static final Pattern INPUT_PATTERN = Pattern.compile("\\\\@input\\{(.+)\\}");
    private final String auxFile;
    private final BibDatabase masterDatabase;

    public AuxParser(String auxFile, BibDatabase database) {
        this.auxFile = auxFile;
        this.masterDatabase = database;
    }

    public AuxParserResult parse() {
        return this.parseAuxFile();
    }

    private AuxParserResult parseAuxFile() {
        AuxParserResult result = new AuxParserResult(this.masterDatabase);
        ArrayList<String> fileList = new ArrayList<String>(1);
        fileList.add(this.auxFile);
        for (int fileIndex = 0; fileIndex < fileList.size(); ++fileIndex) {
            String file = (String)fileList.get(fileIndex);
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = br.readLine()) != null) {
                    this.matchCitation(result, line);
                    this.matchNestedAux(result, fileList, line);
                }
                continue;
            }
            catch (FileNotFoundException e) {
                LOGGER.info("Cannot locate input file", e);
                continue;
            }
            catch (IOException e) {
                LOGGER.warn("Problem opening file", e);
            }
        }
        this.resolveTags(result);
        return result;
    }

    private void matchNestedAux(AuxParserResult result, List<String> fileList, String line) {
        Matcher inputMatch = INPUT_PATTERN.matcher(line);
        while (inputMatch.find()) {
            String inputString;
            String inputFile = inputString = inputMatch.group(1);
            Path rootPath = new File(this.auxFile).toPath().getParent();
            if (rootPath != null) {
                inputFile = rootPath.resolve(inputString).toString();
            }
            if (fileList.contains(inputFile)) continue;
            fileList.add(inputFile);
            result.increaseNestedAuxFilesCounter();
        }
    }

    private void matchCitation(AuxParserResult result, String line) {
        Matcher citeMatch = CITE_PATTERN.matcher(line);
        while (citeMatch.find()) {
            String[] keys;
            String keyString = citeMatch.group(2);
            for (String key : keys = keyString.split(",")) {
                result.getUniqueKeys().add(key.trim());
            }
        }
    }

    private void resolveTags(AuxParserResult result) {
        for (String key : result.getUniqueKeys()) {
            Optional<BibEntry> entry = this.masterDatabase.getEntryByKey(key);
            if (entry.isPresent()) {
                this.insertEntry(entry.get(), result);
                this.resolveCrossReferences(entry.get(), result);
                continue;
            }
            result.getUnresolvedKeys().add(key);
        }
        if (result.getGeneratedBibDatabase().hasEntries()) {
            result.getGeneratedBibDatabase().copyPreamble(this.masterDatabase);
            result.getGeneratedBibDatabase().copyStrings(this.masterDatabase);
        }
    }

    private void resolveCrossReferences(BibEntry entry, AuxParserResult result) {
        entry.getField("crossref").ifPresent(crossref -> {
            if (!result.getGeneratedBibDatabase().getEntryByKey((String)crossref).isPresent()) {
                Optional<BibEntry> refEntry = this.masterDatabase.getEntryByKey((String)crossref);
                if (refEntry.isPresent()) {
                    this.insertEntry(refEntry.get(), result);
                    result.increaseCrossRefEntriesCounter();
                } else {
                    result.getUnresolvedKeys().add((String)crossref);
                }
            }
        });
    }

    private void insertEntry(BibEntry entry, AuxParserResult result) {
        BibEntry clonedEntry = (BibEntry)entry.clone();
        clonedEntry.setId(IdGenerator.next());
        result.getGeneratedBibDatabase().insertEntry(clonedEntry);
    }
}

