/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.autocompleter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sf.jabref.logic.autocompleter.AbstractAutoCompleter;
import net.sf.jabref.logic.autocompleter.AutoCompleteFirstNameMode;
import net.sf.jabref.logic.autocompleter.AutoCompletePreferences;
import net.sf.jabref.model.entry.Author;
import net.sf.jabref.model.entry.AuthorList;
import net.sf.jabref.model.entry.BibEntry;

class NameFieldAutoCompleter
extends AbstractAutoCompleter {
    private final List<String> fieldNames;
    private final boolean lastNameOnlyAndSeparationBySpace;
    private final boolean autoCompFF;
    private final boolean autoCompLF;
    private final AutoCompleteFirstNameMode autoCompFirstnameMode;
    private String prefix = "";

    NameFieldAutoCompleter(String fieldName, AutoCompletePreferences preferences) {
        this(Collections.singletonList(Objects.requireNonNull(fieldName)), false, preferences);
    }

    public NameFieldAutoCompleter(List<String> fieldNames, boolean lastNameOnlyAndSeparationBySpace, AutoCompletePreferences preferences) {
        super(preferences);
        this.fieldNames = Objects.requireNonNull(fieldNames);
        this.lastNameOnlyAndSeparationBySpace = lastNameOnlyAndSeparationBySpace;
        if (preferences.getOnlyCompleteFirstLast()) {
            this.autoCompFF = true;
            this.autoCompLF = false;
        } else if (preferences.getOnlyCompleteLastFirst()) {
            this.autoCompFF = false;
            this.autoCompLF = true;
        } else {
            this.autoCompFF = true;
            this.autoCompLF = true;
        }
        this.autoCompFirstnameMode = preferences.getFirstnameMode() == null ? AutoCompleteFirstNameMode.BOTH : preferences.getFirstnameMode();
    }

    @Override
    public boolean isSingleUnitField() {
        return !this.lastNameOnlyAndSeparationBySpace;
    }

    @Override
    public void addBibtexEntry(BibEntry entry) {
        if (entry == null) {
            return;
        }
        for (String fieldName : this.fieldNames) {
            entry.getField(fieldName).ifPresent(fieldValue -> {
                AuthorList authorList = AuthorList.parse(fieldValue);
                for (Author author : authorList.getAuthors()) {
                    this.handleAuthor(author);
                }
            });
        }
    }

    private String determinePrefixAndReturnRemainder(String str, String delimiter) {
        String result = str;
        int index = result.toLowerCase().lastIndexOf(delimiter);
        if (index >= 0) {
            this.prefix = result.substring(0, index + delimiter.length());
            result = result.substring(index + delimiter.length());
        } else {
            this.prefix = "";
        }
        return result;
    }

    private void handleAuthor(Author author) {
        if (this.lastNameOnlyAndSeparationBySpace) {
            this.addItemToIndex(author.getLastOnly());
        } else {
            if (this.autoCompLF) {
                switch (this.autoCompFirstnameMode) {
                    case ONLY_ABBREVIATED: {
                        this.addItemToIndex(author.getLastFirst(true));
                        break;
                    }
                    case ONLY_FULL: {
                        this.addItemToIndex(author.getLastFirst(false));
                        break;
                    }
                    case BOTH: {
                        this.addItemToIndex(author.getLastFirst(true));
                        this.addItemToIndex(author.getLastFirst(false));
                        break;
                    }
                }
            }
            if (this.autoCompFF) {
                switch (this.autoCompFirstnameMode) {
                    case ONLY_ABBREVIATED: {
                        this.addItemToIndex(author.getFirstLast(true));
                        break;
                    }
                    case ONLY_FULL: {
                        this.addItemToIndex(author.getFirstLast(false));
                        break;
                    }
                    case BOTH: {
                        this.addItemToIndex(author.getFirstLast(true));
                        this.addItemToIndex(author.getFirstLast(false));
                        break;
                    }
                }
            }
        }
    }

    @Override
    public List<String> complete(String toComplete) {
        if (toComplete == null) {
            return new ArrayList<String>();
        }
        String result = this.lastNameOnlyAndSeparationBySpace ? this.determinePrefixAndReturnRemainder(toComplete, " ") : this.determinePrefixAndReturnRemainder(toComplete, " and ");
        return super.complete(result);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    protected int getLengthOfShortestWordToAdd() {
        return 1;
    }
}

