/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.autocompleter;

import java.util.List;
import java.util.Objects;
import net.sf.jabref.logic.autocompleter.AutoCompletePreferences;
import net.sf.jabref.logic.autocompleter.EntireFieldAutoCompleter;
import net.sf.jabref.logic.journals.Abbreviation;
import net.sf.jabref.logic.journals.JournalAbbreviationLoader;
import net.sf.jabref.logic.journals.JournalAbbreviationPreferences;

public class JournalAutoCompleter
extends EntireFieldAutoCompleter {
    private final JournalAbbreviationLoader abbreviationLoader;
    private final JournalAbbreviationPreferences journalAbbreviationPreferences;

    JournalAutoCompleter(String fieldName, AutoCompletePreferences preferences, JournalAbbreviationLoader abbreviationLoader) {
        super(fieldName, preferences);
        this.abbreviationLoader = Objects.requireNonNull(abbreviationLoader);
        this.journalAbbreviationPreferences = preferences.getJournalAbbreviationPreferences();
    }

    @Override
    public List<String> complete(String toComplete) {
        List<String> completions = super.complete(toComplete);
        for (Abbreviation abbreviation : this.abbreviationLoader.getRepository(this.journalAbbreviationPreferences).getAbbreviations()) {
            if (!abbreviation.getName().startsWith(toComplete)) continue;
            completions.add(abbreviation.getName());
        }
        return completions;
    }
}

