/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.autocompleter;

import java.util.Objects;
import net.sf.jabref.logic.autocompleter.AbstractAutoCompleter;
import net.sf.jabref.logic.autocompleter.AutoCompletePreferences;
import net.sf.jabref.model.entry.BibEntry;

class EntireFieldAutoCompleter
extends AbstractAutoCompleter {
    private final String fieldName;

    EntireFieldAutoCompleter(String fieldName, AutoCompletePreferences preferences) {
        super(preferences);
        this.fieldName = Objects.requireNonNull(fieldName);
    }

    @Override
    public boolean isSingleUnitField() {
        return true;
    }

    @Override
    public void addBibtexEntry(BibEntry entry) {
        if (entry == null) {
            return;
        }
        entry.getField(this.fieldName).ifPresent(fieldValue -> this.addItemToIndex(fieldValue.trim()));
    }
}

