/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.autocompleter;

import java.util.Objects;
import java.util.StringTokenizer;
import net.sf.jabref.logic.autocompleter.AbstractAutoCompleter;
import net.sf.jabref.logic.autocompleter.AutoCompletePreferences;
import net.sf.jabref.model.entry.BibEntry;

class DefaultAutoCompleter
extends AbstractAutoCompleter {
    private final String fieldName;
    private static final String SEPARATING_CHARS = ";,\n ";

    DefaultAutoCompleter(String fieldName, AutoCompletePreferences preferences) {
        super(preferences);
        this.fieldName = Objects.requireNonNull(fieldName);
    }

    @Override
    public boolean isSingleUnitField() {
        return false;
    }

    @Override
    public void addBibtexEntry(BibEntry entry) {
        if (entry == null) {
            return;
        }
        entry.getField(this.fieldName).ifPresent(fieldValue -> {
            StringTokenizer tok = new StringTokenizer((String)fieldValue, SEPARATING_CHARS);
            while (tok.hasMoreTokens()) {
                this.addItemToIndex(tok.nextToken());
            }
        });
    }
}

