/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.autocompleter;

import java.util.HashMap;
import java.util.Map;
import net.sf.jabref.logic.autocompleter.AutoCompleter;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;

class AutoCompleters {
    protected final Map<String, AutoCompleter<String>> autoCompleters = new HashMap<String, AutoCompleter<String>>();

    AutoCompleters() {
    }

    public AutoCompleter<String> get(String fieldName) {
        return this.autoCompleters.get(fieldName);
    }

    protected void addDatabase(BibDatabase database) {
        for (BibEntry entry : database.getEntries()) {
            this.addEntry(entry);
        }
    }

    public void addEntry(BibEntry bibEntry) {
        for (AutoCompleter<String> autoCompleter : this.autoCompleters.values()) {
            autoCompleter.addBibtexEntry(bibEntry);
        }
    }

    protected void put(String field, AutoCompleter<String> autoCompleter) {
        this.autoCompleters.put(field, autoCompleter);
    }
}

