/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.autocompleter;

import java.util.Objects;
import net.sf.jabref.logic.autocompleter.AutoCompletePreferences;
import net.sf.jabref.logic.autocompleter.AutoCompleter;
import net.sf.jabref.logic.autocompleter.BibtexKeyAutoCompleter;
import net.sf.jabref.logic.autocompleter.DefaultAutoCompleter;
import net.sf.jabref.logic.autocompleter.JournalAutoCompleter;
import net.sf.jabref.logic.autocompleter.NameFieldAutoCompleter;
import net.sf.jabref.logic.journals.JournalAbbreviationLoader;
import net.sf.jabref.model.entry.FieldProperty;
import net.sf.jabref.model.entry.InternalBibtexFields;

public class AutoCompleterFactory {
    private final AutoCompletePreferences preferences;
    private final JournalAbbreviationLoader abbreviationLoader;

    public AutoCompleterFactory(AutoCompletePreferences preferences, JournalAbbreviationLoader abbreviationLoader) {
        this.preferences = Objects.requireNonNull(preferences);
        this.abbreviationLoader = Objects.requireNonNull(abbreviationLoader);
    }

    public AutoCompleter<String> getFor(String fieldName) {
        Objects.requireNonNull(fieldName);
        if (InternalBibtexFields.getFieldProperties(fieldName).contains((Object)FieldProperty.PERSON_NAMES)) {
            return new NameFieldAutoCompleter(fieldName, this.preferences);
        }
        if (InternalBibtexFields.getFieldProperties(fieldName).contains((Object)FieldProperty.SINGLE_ENTRY_LINK)) {
            return new BibtexKeyAutoCompleter(this.preferences);
        }
        if (InternalBibtexFields.getFieldProperties(fieldName).contains((Object)FieldProperty.JOURNAL_NAME) || "publisher".equals(fieldName)) {
            return new JournalAutoCompleter(fieldName, this.preferences, this.abbreviationLoader);
        }
        return new DefaultAutoCompleter(fieldName, this.preferences);
    }

    public AutoCompleter<String> getPersonAutoCompleter() {
        return new NameFieldAutoCompleter(InternalBibtexFields.getPersonNameFields(), true, this.preferences);
    }
}

