/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.autocompleter;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.jabref.logic.autocompleter.AutoCompleteFirstNameMode;
import net.sf.jabref.logic.journals.JournalAbbreviationPreferences;
import net.sf.jabref.preferences.JabRefPreferences;

public class AutoCompletePreferences {
    private final JabRefPreferences preferences;
    private static final String AUTOCOMPLETER_SHORTEST_TO_COMPLETE = "shortestToComplete";
    private static final String AUTOCOMPLETER_FIRSTNAME_MODE = "autoCompFirstNameMode";
    private static final String AUTOCOMPLETER_LAST_FIRST = "autoCompLF";
    private static final String AUTOCOMPLETER_FIRST_LAST = "autoCompFF";
    private static final String AUTOCOMPLETER_COMPLETE_FIELDS = "autoCompleteFields";

    public static void putDefaults(Map<String, Object> defaults) {
        defaults.put(AUTOCOMPLETER_SHORTEST_TO_COMPLETE, 1);
        defaults.put(AUTOCOMPLETER_FIRSTNAME_MODE, AutoCompleteFirstNameMode.BOTH.name());
        defaults.put(AUTOCOMPLETER_FIRST_LAST, Boolean.FALSE);
        defaults.put(AUTOCOMPLETER_LAST_FIRST, Boolean.FALSE);
        defaults.put(AUTOCOMPLETER_COMPLETE_FIELDS, "author;editor;title;journal;publisher;keywords");
    }

    public AutoCompletePreferences(JabRefPreferences preferences) {
        this.preferences = Objects.requireNonNull(preferences);
    }

    public int getShortestLengthToComplete() {
        return this.preferences.getInt(AUTOCOMPLETER_SHORTEST_TO_COMPLETE);
    }

    public void setShortestLengthToComplete(Integer value) {
        this.preferences.putInt(AUTOCOMPLETER_SHORTEST_TO_COMPLETE, value);
    }

    public AutoCompleteFirstNameMode getFirstnameMode() {
        try {
            return AutoCompleteFirstNameMode.valueOf(this.preferences.get(AUTOCOMPLETER_FIRSTNAME_MODE));
        }
        catch (IllegalArgumentException ex) {
            return AutoCompleteFirstNameMode.BOTH;
        }
    }

    public void setFirstnameMode(AutoCompleteFirstNameMode mode) {
        this.preferences.put(AUTOCOMPLETER_FIRSTNAME_MODE, mode.name());
    }

    public boolean getOnlyCompleteLastFirst() {
        return this.preferences.getBoolean(AUTOCOMPLETER_LAST_FIRST);
    }

    public void setOnlyCompleteLastFirst(boolean value) {
        this.preferences.putBoolean(AUTOCOMPLETER_LAST_FIRST, value);
    }

    public boolean getOnlyCompleteFirstLast() {
        return this.preferences.getBoolean(AUTOCOMPLETER_FIRST_LAST);
    }

    public void setOnlyCompleteFirstLast(boolean value) {
        this.preferences.putBoolean(AUTOCOMPLETER_FIRST_LAST, value);
    }

    public List<String> getCompleteNames() {
        return this.preferences.getStringList(AUTOCOMPLETER_COMPLETE_FIELDS);
    }

    public String getCompleteNamesAsString() {
        return this.preferences.get(AUTOCOMPLETER_COMPLETE_FIELDS);
    }

    public void setCompleteNames(String value) {
        this.preferences.put(AUTOCOMPLETER_COMPLETE_FIELDS, value);
    }

    public JournalAbbreviationPreferences getJournalAbbreviationPreferences() {
        return this.preferences.getJournalAbbreviationPreferences();
    }
}

