/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.autocompleter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jabref.logic.autocompleter.AutoCompletePreferences;
import net.sf.jabref.logic.autocompleter.AutoCompleter;
import net.sf.jabref.logic.layout.format.LatexToUnicodeFormatter;

public abstract class AbstractAutoCompleter
implements AutoCompleter<String> {
    private static final int SHORTEST_WORD_TO_ADD = 4;
    private final AutoCompletePreferences preferences;
    private final TreeSet<String> indexCaseSensitive = new TreeSet();
    private final TreeSet<String> indexCaseInsensitive = new TreeSet();
    private final Map<String, Set<String>> possibleStringsForSearchString = new HashMap<String, Set<String>>();

    public AbstractAutoCompleter(AutoCompletePreferences preferences) {
        this.preferences = Objects.requireNonNull(preferences);
    }

    @Override
    public List<String> complete(String toComplete) {
        if (toComplete == null) {
            return new ArrayList<String>();
        }
        if (this.isTooShortToComplete(toComplete)) {
            return new ArrayList<String>();
        }
        String lowerCase = toComplete.toLowerCase();
        if (lowerCase.equals(toComplete)) {
            String ender = AbstractAutoCompleter.incrementLastCharacter(lowerCase);
            SortedSet<String> subset = this.indexCaseInsensitive.subSet(lowerCase, ender);
            ArrayList<String> result = new ArrayList<String>();
            for (String s : subset) {
                result.addAll((Collection<String>)this.possibleStringsForSearchString.get(s));
            }
            return result;
        }
        String ender = AbstractAutoCompleter.incrementLastCharacter(toComplete);
        SortedSet<String> subset = this.indexCaseSensitive.subSet(toComplete, ender);
        return new ArrayList<String>(subset);
    }

    private static String incrementLastCharacter(String toIncrement) {
        if (toIncrement.isEmpty()) {
            return "";
        }
        char lastChar = toIncrement.charAt(toIncrement.length() - 1);
        return toIncrement.substring(0, toIncrement.length() - 1) + Character.toString((char)(lastChar + '\u0001'));
    }

    private boolean isTooShortToComplete(String toCheck) {
        return toCheck.length() < this.preferences.getShortestLengthToComplete();
    }

    @Override
    public void addItemToIndex(String word) {
        if (word.length() < this.getLengthOfShortestWordToAdd()) {
            return;
        }
        word = new LatexToUnicodeFormatter().format(word);
        this.indexCaseSensitive.add(word);
        String lowerCase = word.toLowerCase();
        this.indexCaseInsensitive.add(lowerCase);
        Set<String> set = this.possibleStringsForSearchString.get(lowerCase);
        if (set == null) {
            set = new TreeSet<String>();
        }
        set.add(word);
        this.possibleStringsForSearchString.put(lowerCase, set);
    }

    @Override
    public String getPrefix() {
        return "";
    }

    @Override
    public String getAutoCompleteText(String item) {
        return item;
    }

    protected int getLengthOfShortestWordToAdd() {
        return 4;
    }
}

