/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.sf.jabref.model.EntryTypes;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.EntryType;
import net.sf.jabref.model.entry.FileField;
import net.sf.jabref.model.entry.ParsedFileField;
import net.sf.jabref.model.strings.StringUtil;

public class TypedBibEntry {
    private final BibEntry entry;
    private final Optional<BibDatabase> database;
    private final BibDatabaseMode mode;

    public TypedBibEntry(BibEntry entry, BibDatabaseMode mode) {
        this(entry, Optional.empty(), mode);
    }

    private TypedBibEntry(BibEntry entry, Optional<BibDatabase> database, BibDatabaseMode mode) {
        this.entry = Objects.requireNonNull(entry);
        this.database = Objects.requireNonNull(database);
        this.mode = mode;
    }

    public TypedBibEntry(BibEntry entry, BibDatabaseContext databaseContext) {
        this(entry, Optional.of(databaseContext.getDatabase()), databaseContext.getMode());
    }

    public boolean hasAllRequiredFields() {
        Optional<EntryType> type = EntryTypes.getType(this.entry.getType(), this.mode);
        if (type.isPresent()) {
            return this.entry.allFieldsPresent(type.get().getRequiredFields(), this.database.orElse(null));
        }
        return true;
    }

    public String getTypeForDisplay() {
        Optional<EntryType> entryType = EntryTypes.getType(this.entry.getType(), this.mode);
        if (entryType.isPresent()) {
            return entryType.get().getName();
        }
        return StringUtil.capitalizeFirst(this.entry.getType());
    }

    public List<ParsedFileField> getFiles() {
        Optional<String> oldValue = this.entry.getField("file");
        if (!oldValue.isPresent()) {
            return new ArrayList<ParsedFileField>();
        }
        return FileField.parse(oldValue.get());
    }

    public Optional<FieldChange> setFiles(List<ParsedFileField> files) {
        Optional<String> oldValue = this.entry.getField("file");
        String newValue = FileField.getStringRepresentation(files);
        if (oldValue.isPresent() && oldValue.get().equals(newValue)) {
            return Optional.empty();
        }
        this.entry.setField("file", newValue);
        return Optional.of(new FieldChange(this.entry, "file", oldValue.orElse(""), newValue));
    }
}

