/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.sf.jabref.model.EntryTypes;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.CustomEntryType;
import net.sf.jabref.model.entry.EntryType;
import net.sf.jabref.preferences.JabRefPreferences;

public class CustomEntryTypesManager {
    public static final List<EntryType> ALL = new ArrayList<EntryType>();

    public static void loadCustomEntryTypes(JabRefPreferences prefs) {
        Optional<CustomEntryType> type;
        int number = 0;
        while ((type = prefs.getCustomEntryType(number)).isPresent()) {
            EntryTypes.addOrModifyCustomEntryType(type.get());
            ALL.add(type.get());
            ++number;
        }
    }

    public static void saveCustomEntryTypes(JabRefPreferences prefs) {
        Iterator<EntryType> iterator = EntryTypes.getAllValues(BibDatabaseMode.BIBTEX).iterator();
        int number = 0;
        while (iterator.hasNext()) {
            EntryType entryType = iterator.next();
            if (!(entryType instanceof CustomEntryType)) continue;
            prefs.storeCustomEntryType((CustomEntryType)entryType, number);
            ++number;
        }
        prefs.purgeCustomEntryTypes(number);
    }
}

